/*
 * BenchmarkSubscriber.C
 *
 *  Created on: 11.07.2012
 *      Author: erik
 */



#include <MOOSLIB/MOOSApp.h>

#include <sstream>

#include "../BenchmarkStats.h"



class Subscriber : public CMOOSApp
{
public:
	Subscriber() : b("Subscriber")
	{
		SetCommsFreq(200);
	}
	virtual ~Subscriber()
	{

	}

	BenchmarkStats b;

protected:

	bool OnConnectToServer()
	{
		m_Comms.Register("Benchmark",0);
	}

    bool OnNewMail(MOOSMSG_LIST &NewMail)
    {

        for(MOOSMSG_LIST::iterator p=NewMail.begin();p!=NewMail.end();p++)
        {
        	CMOOSMsg& msg = *p;
        	onData(msg.GetString());
        }
    }

    void onData(const std::string& data)
    {
    	std::stringstream ss(data);
    	uint64_t s;
    	ss >> s;
    	b.toc(s);
    }


};



int main(int argc ,char * argv[])
{
	//make an application
	Subscriber subscriber;

	//run forever pasing registration name and mission file parameters
	subscriber.Run("Subscriber", "dummy.moos");

	//probably will never get here..
	return 0;
}


