/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file RPCHandler.C
 *    Implementation of RPCHandler.
 *
 * @author Erik Einhorn
 * @date   2010/11/25
 */

#include <fw/RPCHandler.h>

#include <error/Logging.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

void RPCHandler::InvokerRunnable::run(DispatcherThread* dispatcher)
{
	// handle all queued request invokers
	try {
		// invoke the RPC call from within this thread
		// if the invoker has finished the call, it will notify its associated
		// FinishHandler that usually will send the result to the sender of the
		// request.
		mInvoker->invoke();

		if(mHandler->getDiagnosticsModule())
			mHandler->getDiagnosticsModule()->ok(mInvoker->getServiceName());
	}
	catch(Exception& ex) {
		if (!mHandler->getDiagnosticsModule() ||
				mHandler->getDiagnosticsModule()->error(mInvoker->getServiceName(),
				                                        ex.message(),
				                                        "Exception while invoking RPC handler")) {
			MIRA_LOG_EXCEPTION(ERROR,ex) << "Exception:\n";
		}
	}
	catch(std::exception& ex) {
		if (!mHandler->getDiagnosticsModule() ||
			mHandler->getDiagnosticsModule()->error(mInvoker->getServiceName(),
			                                        ex.what(),
			                                        "Exception while invoking RPC handler")) {
			MIRA_LOG_EXCEPTION(ERROR,ex) << "Exception:\n";
		}
	}
}

void RPCHandler::queueRequest(AbstractDeferredInvokerPtr invoker)
{
	InvokerRunnablePtr invokerRunnable(new InvokerRunnable(this, invoker));
	mDispatcher->insertRunnable(invokerRunnable, true);
}

///////////////////////////////////////////////////////////////////////////////

}
