/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file CommonTapeRenderer.C
 *    Common renderer plugins.
 *
 * @author Tim Langner
 * @date   2011/12/30
 */

#include <TapeTextRenderer.h>
#include <TapePlotRenderer.h>

namespace mira {

//////////////////////////////////////////////////////////////////////////////

MIRA_REGISTER_TEXTRENDERER(Tapeuint8Renderer, uint8)
MIRA_REGISTER_TEXTRENDERER(Tapeuint16Renderer, uint16)
MIRA_REGISTER_TEXTRENDERER(Tapeuint32Renderer, uint32)
MIRA_REGISTER_TEXTRENDERER(Tapeuint64Renderer, uint64)
MIRA_REGISTER_TEXTRENDERER(Tapeint8Renderer, int8)
MIRA_REGISTER_TEXTRENDERER(Tapeint16Renderer, int16)
MIRA_REGISTER_TEXTRENDERER(Tapeint32Renderer, int32)
MIRA_REGISTER_TEXTRENDERER(Tapeint64Renderer, int64)
MIRA_REGISTER_TEXTRENDERER(TapeboolRenderer, bool)
MIRA_REGISTER_TEXTRENDERER(TapefloatRenderer, float)
MIRA_REGISTER_TEXTRENDERER(TapedoubleRenderer, double)
MIRA_REGISTER_TEXTRENDERER(TapestringRenderer, std::string)

//////////////////////////////////////////////////////////////////////////////

MIRA_REGISTER_PLOTRENDERER(Tapeuint8PlotRenderer, uint8)
MIRA_REGISTER_PLOTRENDERER(Tapeuint16PlotRenderer, uint16)
MIRA_REGISTER_PLOTRENDERER(Tapeuint32PlotRenderer, uint32)
MIRA_REGISTER_PLOTRENDERER(Tapeuint64PlotRenderer, uint64)
MIRA_REGISTER_PLOTRENDERER(Tapeint8PlotRenderer, int8)
MIRA_REGISTER_PLOTRENDERER(Tapeint16PlotRenderer, int16)
MIRA_REGISTER_PLOTRENDERER(Tapeint32PlotRenderer, int32)
MIRA_REGISTER_PLOTRENDERER(Tapeint64PlotRenderer, int64)
MIRA_REGISTER_PLOTRENDERER(TapefloatPlotRenderer, float)
MIRA_REGISTER_PLOTRENDERER(TapedoublePlotRenderer, double)


//////////////////////////////////////////////////////////////////////////////

} // namespace

MIRA_CLASS_SERIALIZATION(mira::Tapeuint8Renderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::Tapeuint16Renderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::Tapeuint32Renderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::Tapeuint64Renderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::Tapeint8Renderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::Tapeint16Renderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::Tapeint32Renderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::Tapeint64Renderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::TapeboolRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::TapefloatRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::TapedoubleRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::TapestringRenderer, mira::TapeDataRenderer)

//////////////////////////////////////////////////////////////////////////////

MIRA_CLASS_SERIALIZATION(mira::Tapeuint8PlotRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::Tapeuint16PlotRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::Tapeuint32PlotRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::Tapeuint64PlotRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::Tapeint8PlotRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::Tapeint16PlotRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::Tapeint32PlotRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::Tapeint64PlotRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::TapefloatPlotRenderer, mira::TapeDataRenderer)
MIRA_CLASS_SERIALIZATION(mira::TapedoublePlotRenderer, mira::TapeDataRenderer)
