/*
 * Copyright (C) by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PlotMarker.h
 *    A fixed version of QwtPlotMarker
 *
 * @author Christof Schröter
 * @date   2021/04/14
 */

#ifndef _MIRA_QWT_PLOTMARKER_H_
#define _MIRA_QWT_PLOTMARKER_H_

#include <qwt_plot_marker.h>

namespace mira {
namespace qwt {

///////////////////////////////////////////////////////////////////////////////

class PlotMarker : public QwtPlotMarker
{
public:
	using QwtPlotMarker::QwtPlotMarker; // inherit constructors

#if (QWT_VERSION < 0x060104)
	// backport fixed boundingRect() implementation from Qwt 6.1.4 ff.
	QRectF boundingRect() const
	{
		// width/height of -1 does not affect the autoscale calculation

		switch (lineStyle())
		{
			case QwtPlotMarker::HLine:
				return QRectF( xValue(), yValue(), -1.0, 0.0 );

			case QwtPlotMarker::VLine:
				return QRectF( xValue(), yValue(), 0.0, -1.0 );

			default :
				return QRectF( xValue(), yValue(), 0.0, 0.0 );
		}
	}
#endif
};

///////////////////////////////////////////////////////////////////////////////

}}

#endif 
