/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file VisualizationPlotView.h
 *    Abstract base class of a visualization view for plotting data in 2d using Qwt.
 *
 * @author Erik Einhorn, Ronny Stricker
 * @date   2014/03/12
 */

#ifndef _MIRA_VISUALIZATIONGRAPHVIEW_H_
#define _MIRA_VISUALIZATIONGRAPHVIEW_H_

#include <QDragMoveEvent>
#include <QGraphicsView>

#include <views/VisualizationView.h>
#include <views/GraphView.h>

class QToolButton;
class QCheckBox;

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class MIRA_GRAPHVISUALIZATION_EXPORT IVisualizationGraphSite : public IVisualizationSite
{
public:
	virtual GraphView* getGraphView() = 0;
};

///////////////////////////////////////////////////////////////////////////////

/**
 * Class for visualizing SVG based graphs.
 */
class MIRA_GRAPHVISUALIZATION_EXPORT VisualizationGraphView : public VisualizationView, public IVisualizationGraphSite
{
	Q_OBJECT

	MIRA_META_OBJECT(VisualizationGraphView,
					("Name", "Graph Plot View")
					("Description", "View for plotting graphs")
					("Category"   , "Visualization")
					("Visualization", "mira::VisualizationGraph<std::string>"))

public:
	VisualizationGraphView();

	virtual ~VisualizationGraphView()
	{
		destroyVisualizations();
	}

public:

	template <typename Reflector>
	void reflect(Reflector& r)
	{
		MIRA_REFLECT_BASE(r, VisualizationView);
	}

public: // implementation of VisualizationView

	virtual void addVisualization(Visualization* vis);

	virtual const Class& supportedVisualizationClass() const;

	virtual const Class& defaultVisualizationClass() const;

public:
	virtual GraphView* getGraphView()
	{
		return mView;
	}

protected:

	virtual QWidget* createVisualizationPart();

	void setupVisualizations();

	virtual void update(Duration dt);

protected slots:

	void setAutoScale(bool enabled);

protected:

	GraphView* mView;
	QGraphicsScene* mScene;
	QGraphicsItem* mGraphItem;
	QSvgRenderer* mSvgRenderer;

	QToolButton* mBtSaveGraph;
	QCheckBox* mCbAutoScale;

};

///////////////////////////////////////////////////////////////////////////////

}

#endif 
