/*
 * Copyright (C) by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file ServiceLevelTestUnit.C
 *
 * @author Christof Schröter
 * @date   2021/10/04
 */

#include <image/Img.h>

#include <fw/Unit.h>

namespace mira { namespace fw { namespace test {

///////////////////////////////////////////////////////////////////////////////

class ServiceLevelUnit : public Unit
{
	MIRA_OBJECT(ServiceLevelUnit)
public:

	ServiceLevelUnit() :
		Unit(Duration::milliseconds(200)), mCount(0), mPublish(false)
	{
	}

	/// Reflect method for serialization and services
	template<typename Reflector>
	void reflect(Reflector& r)
	{
		MIRA_REFLECT_BASE(r, Unit);

		r.roproperty("PublishCount", mCount, "Count of channel posts");
		r.method("enablePublish", &ServiceLevelUnit::enablePublish, this,
		         "start/stop publishing",
		         "publish", "whether to enable publishing", true);
	}

	virtual void initialize()
	{
		mImgChannel1 = publish<Img8U1>("Img1");
		mImgChannel2 = publish<Img8U1>("Img2");
		publishService(*this);
	}

	virtual void process(const Timer& timer)
	{
		if (!mPublish)
			return;

		Img8U1 img(100, 100);
		img = ++mCount % 255;
		mImgChannel1.post(img);
		mImgChannel2.post(img);
	}

	void enablePublish(bool publish)
	{
		mPublish = publish;
	}

protected:
	Channel<Img8U1> mImgChannel1;
	Channel<Img8U1> mImgChannel2;
	int mCount;
	bool mPublish;
};

///////////////////////////////////////////////////////////////////////////////

}}}

MIRA_CLASS_SERIALIZATION( mira::fw::test::ServiceLevelUnit, mira::Unit );
