/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file FrameworkDefines.h
 *    Defines and constants for the framework.
 *
 * @author Tim Langner
 * @date   2012/03/29
 */

#ifndef _MIRA_FRAMEWORKDEFINES_H_
#define _MIRA_FRAMEWORKDEFINES_H_

///////////////////////////////////////////////////////////////////////////////

/// Calculate the major version of v
#define MIRA_MAJOR_VERSION(v) ((v) >> 16)
/// Calculate the minor version of v
#define MIRA_MINOR_VERSION(v) ((v) & 0x0000FFFF)

/**
 * Version of the communication protocol between frameworks
 *
 * History:
 *  - 0x00030003:
 *    - Time offset is estimated in outgoing connection only and applied to
 *      both sent and received channel messages (previously: offset estimated
 *      on both sides independently, applied to received messages only)
 *    - Added ServiceLevel::interval (limit update rate on subscribed remote channel)
 *
 *  - 0x00030002:
 *    - Introduced BinarySerializer format v2
 *
 *  - 0x00030001:
 *    - Added protocol version of server to CONNECT_ACCEPT_MSG message
 *    - Added message PING_MSG
 */
#define MIRA_PROTOCOL_VERSION 0x00030003

/// Version of the latest tape format
#define MIRA_TAPE_VERSION 0x00060000

/**
 * Port for multicast for auto discovery service
 * (http://www.networksorcery.com/enp/protocol/ip/ports08000.htm says that
 * this port is unused)
 */
#define MIRA_AUTODISCOVERY_MULTICAST_PORT 8119

/**
 * Address for multicast for auto discovery service
 * (multicast address space is from 224.0.0.0 to 239.255.255.255)
 */
#define MIRA_AUTODISCOVERY_MULTICAST_ADDRESS "231.1.1.1"

///////////////////////////////////////////////////////////////////////////////

#endif
