/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file NumericalStreamTest.C
 *    Test case for streaming numbers
 *
 * @author Erik Einhorn
 * @date 2012/03/27
 */

#include <boost/test/unit_test.hpp>

#include <stream/NumericalStream.h>

using namespace mira;

BOOST_AUTO_TEST_CASE( NumericalStreamTest )
{
	std::stringstream ss;
	NumericalOstream os(ss);

	os << 1234 << std::endl;
	os << 1.2345f << "Test" << std::endl;

	int i;
	float f;
	std::string s;

	NumericalIstream is(ss);
	is >> i >> f >> s;

	BOOST_CHECK_EQUAL(i,1234);
	BOOST_CHECK_CLOSE(f,1.2345f, 0.01f);
	BOOST_CHECK_EQUAL(s,"Test");
}

BOOST_AUTO_TEST_CASE( NumericalStreamHexTest )
{
	std::stringstream ss;
	NumericalOstream os(ss);

	os << std::hex << 1234;

	int i;

	NumericalIstream is(ss);
	is >> std::hex >> i;

	BOOST_CHECK_EQUAL(i,1234);
}

BOOST_AUTO_TEST_CASE( NumericalStreamNanInfTest)
{
	std::stringstream ss;
	NumericalOstream os(ss);

	os << std::numeric_limits<float>::infinity() << "Test" << std::endl << 1.234f;
	os << std::numeric_limits<float>::quiet_NaN() << -std::numeric_limits<float>::infinity();

	float f;
	std::string s;

	NumericalIstream is(ss);
	is >> f >> s;
	BOOST_CHECK(boost::math::isinf(f));
	BOOST_CHECK_EQUAL(s, "Test");

	is >> f;
	BOOST_CHECK_CLOSE(f,1.234f, 0.01f);

	is >> f;
	BOOST_CHECK(boost::math::isnan(f));

	is >> f;
	BOOST_CHECK(boost::math::isinf(f));
	BOOST_CHECK(f<0);
}


BOOST_AUTO_TEST_CASE( NumericalStreamNanInfErrTest)
{
	std::stringstream ss;
	NumericalOstream os(ss);

	os << "in";

	float f;

	NumericalIstream is(ss);
	is >> f;
	BOOST_CHECK(ss.fail());
}

