/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file Dependency.h
 *
 * @author Ronny Stricker
 * @date   2012/03/27
 */


#include <core/Package.h>

#ifndef _MIRA_DEPENDENCY_H_
#define _MIRA_DEPENDENCY_H_

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * @brief Represents a dependency.
 * A dependency is an extended package with additional flags.
 */
class Dependency : public Package
{
	MIRA_OBJECT( Dependency )

public:
	enum DependencyFlags {
		NONE = 0x0000,            /// no flags specified
		FACULTATIVE    = 0x0001,  /// if the package is a optional one
		RUNTIME        = 0x0002,  /// package is runtime dependency
		VERSION_OK     = 0x0004,  /// version of the package is okay (for dependency resolving)
		VERSION_INCOMP = 0x0008   /// version of the package is incompatible (for dependency resolving)
	};

	MIRA_ENUM_TO_FLAGS_INCLASS( DependencyFlags );

public:
	Dependency();

	Dependency( std::string const& name );

	Dependency( std::string const& name, Package::Version const& version,
			DependencyFlags const& flags );

	virtual ~Dependency();

	template <class Reflector>
	void reflect( Reflector& r ) {

		r.member("name", mName, "Name of package group.");
		r.member("Version",mVersion,"");
		r.member("flags", mDepFlag, "");
	}

	virtual Dependency* createCopy() const;

	/**
	 * @brief Returns a deep copy of this, which can be used as dependency.
	 * All packages (children) will be returned as dependency type.
	 */
	virtual Package* createDependency() const;

public:
	DependencyFlags mDepFlag;

};

///////////////////////////////////////////////////////////////////////////////

}

#endif
