/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file TransformTreeTextView.h
 *    Shows structure of the transformation tree in textual form.
 *
 * @author Christof Schroeter
 * @date   2013/05/24
 */

#ifndef _MIRA_TRANSFORMTREEVIEW_H_
#define _MIRA_TRANSFORMTREEVIEW_H_

#include <serialization/GetterSetter.h>

#include <rcp/EditorPart.h>

class QTreeWidgetItem;

namespace mira { 

///////////////////////////////////////////////////////////////////////////////

class TransformTreeWidget;

/**
 * Shows structure of the transformation tree in textual form.
 */
class TransformTreeTextView : public mira::EditorPart
{
Q_OBJECT
MIRA_META_OBJECT(TransformTreeTextView,
                ("Category", "Information")
                ("Name", "Transformation Tree")
                ("Description", "Shows structure of the transformation tree in textual form."))

public:

	TransformTreeTextView();

public:

	template <typename Reflector>
	void reflect(Reflector& r)
	{
		MIRA_REFLECT_BASE(r, EditorPart);
		r.member("ShowCovarianceMap",
		         getter(&TransformTreeTextView::getShowCovarianceMap, this),
		         setter(&TransformTreeTextView::setShowCovarianceMap, this),
		         "Map of node IDs and whether to show their covariance", std::map<std::string, bool>());
		r.member("RelativePoseNodeID",
		         getter(&TransformTreeTextView::getRelativePoseNodeID, this),
		         setter(&TransformTreeTextView::setRelativePoseNodeID, this),
		         "ID of reference node for relative pose", "");
	}

protected:

	virtual QWidget* createPartControl();

	virtual void timerEvent(QTimerEvent *event);

private:

	void updateTree();

	std::map<std::string, bool> getShowCovarianceMap() const;
	void setShowCovarianceMap(const std::map<std::string, bool>& check);

	std::string getRelativePoseNodeID() const;
	void setRelativePoseNodeID(const std::string& id);

private:

	TransformTreeWidget* ui;

	int mUpdateTimer;

	std::string mSelectID;
	std::map<std::string, bool> mCheckCov;
};

///////////////////////////////////////////////////////////////////////////////

} //namespace

#endif
