/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file StandardDataTypesVisualization.C
 *    Plot visualizations for standard data types.
 *
 * @author Tim Langner
 * @date   2011/03/14
 */

#include <visualization/plot/VisualizationPlotCurveJSON.h>

namespace mira {

MIRA_JSON_PLOT_CURVE_VISUALIZATION(Int8PlotVisualization, int8, "Int", "Integer 8bit", "Visualization of 8bit integer values", "Standard Datatypes")
MIRA_JSON_PLOT_CURVE_VISUALIZATION(Int16PlotVisualization, int16, "Int", "Integer 16bit", "Visualization of 16bit integer values", "Standard Datatypes")
MIRA_JSON_PLOT_CURVE_VISUALIZATION(Int32PlotVisualization, int32, "Int", "Integer 32bit", "Visualization of 32bit integer values", "Standard Datatypes")
MIRA_JSON_PLOT_CURVE_VISUALIZATION(Int64PlotVisualization, int64, "Int", "Integer 64bit", "Visualization of 64bit integer values", "Standard Datatypes")
MIRA_JSON_PLOT_CURVE_VISUALIZATION(UInt8PlotVisualization, uint8, "Int", "Unsigned integer 8bit", "Visualization of 8bit unsigned integer values", "Standard Datatypes")
MIRA_JSON_PLOT_CURVE_VISUALIZATION(UInt16PlotVisualization, uint16, "Int", "Unsigned integer 16bit", "Visualization of 16bit unsigned integer values", "Standard Datatypes")
MIRA_JSON_PLOT_CURVE_VISUALIZATION(UInt32PlotVisualization, uint32, "Int", "Unsigned integer 32bit", "Visualization of 32bit unsigned integer values", "Standard Datatypes")
MIRA_JSON_PLOT_CURVE_VISUALIZATION(UInt64PlotVisualization, uint64, "Int", "Unsigned integer 64bit", "Visualization of 64bit unsigned integer values", "Standard Datatypes")

MIRA_JSON_PLOT_CURVE_VISUALIZATION(BoolPlotVisualization, bool, "Bool", "Boolean value", "Visualization of boolean values", "Standard Datatypes")
MIRA_JSON_PLOT_CURVE_VISUALIZATION(FloatPlotVisualization, float, "Float", "Floating point value 32bit", "Visualization of 32bit floating point values", "Standard Datatypes")
MIRA_JSON_PLOT_CURVE_VISUALIZATION(DoublePlotVisualization, double, "Double", "Floating point value double precision", "Visualization of double precision floating point values", "Standard Datatypes")

}


MIRA_CLASS_SERIALIZATION( mira::Int8PlotVisualization, mira::VisualizationPlotCurve);
MIRA_CLASS_SERIALIZATION( mira::Int16PlotVisualization, mira::VisualizationPlotCurve);
MIRA_CLASS_SERIALIZATION( mira::Int32PlotVisualization, mira::VisualizationPlotCurve);
MIRA_CLASS_SERIALIZATION( mira::Int64PlotVisualization, mira::VisualizationPlotCurve);
MIRA_CLASS_SERIALIZATION( mira::UInt8PlotVisualization, mira::VisualizationPlotCurve);
MIRA_CLASS_SERIALIZATION( mira::UInt16PlotVisualization, mira::VisualizationPlotCurve);
MIRA_CLASS_SERIALIZATION( mira::UInt32PlotVisualization, mira::VisualizationPlotCurve);
MIRA_CLASS_SERIALIZATION( mira::UInt64PlotVisualization, mira::VisualizationPlotCurve);

MIRA_CLASS_SERIALIZATION( mira::BoolPlotVisualization, mira::VisualizationPlotCurve);
MIRA_CLASS_SERIALIZATION( mira::FloatPlotVisualization, mira::VisualizationPlotCurve);
MIRA_CLASS_SERIALIZATION( mira::DoublePlotVisualization, mira::VisualizationPlotCurve);
