/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file StandardDataTypesThresholdVisualization.C
 *    Plot visualizations for standard data types.
 *
 * @author Tim Langner
 * @date   2011/03/14
 */

#include <visualization/VisualizationPlotThreshold.h>

namespace mira {

MIRA_PLOT_THRESHOLD_VISUALIZATIONS_DEFINITION(Int8, int8, "Int", "Integer 8bit threshold", "Visualization of 8bit integer thresholds")
MIRA_PLOT_THRESHOLD_VISUALIZATIONS_DEFINITION(Int16, int16, "Int", "Integer 16bit threshold", "Visualization of 16bit integer thresholds")
MIRA_PLOT_THRESHOLD_VISUALIZATIONS_DEFINITION(Int32, int32, "Int", "Integer 32bit threshold", "Visualization of 32bit integer thresholds")
MIRA_PLOT_THRESHOLD_VISUALIZATIONS_DEFINITION(Int64, int64, "Int", "Integer 64bit threshold", "Visualization of 64bit integer thresholds")
MIRA_PLOT_THRESHOLD_VISUALIZATIONS_DEFINITION(UInt8, uint8, "Int", "Unsigned integer 8bit threshold", "Visualization of 8bit unsigned integer thresholds")
MIRA_PLOT_THRESHOLD_VISUALIZATIONS_DEFINITION(UInt16, uint16, "Int", "Unsigned integer 16bit threshold", "Visualization of 16bit unsigned integer thresholds")
MIRA_PLOT_THRESHOLD_VISUALIZATIONS_DEFINITION(UInt32, uint32, "Int", "Unsigned integer 32bit threshold", "Visualization of 32bit unsigned integer thresholds")
MIRA_PLOT_THRESHOLD_VISUALIZATIONS_DEFINITION(UInt64, uint64, "Int", "Unsigned integer 64bit threshold", "Visualization of 64bit unsigned integer thresholds")

MIRA_PLOT_THRESHOLD_VISUALIZATIONS_DEFINITION(Float, float, "Float", "Floating point threshold 32bit", "Visualization of 32bit floating point thresholds")
MIRA_PLOT_THRESHOLD_VISUALIZATIONS_DEFINITION(Double, double, "Double", "Floating point threshold double precision", "Visualization of double precision floating point thresholds")

}


MIRA_PLOT_THRESHOLD_VISUALIZATIONS_SERIALIZATION(Int8);
MIRA_PLOT_THRESHOLD_VISUALIZATIONS_SERIALIZATION(Int16);
MIRA_PLOT_THRESHOLD_VISUALIZATIONS_SERIALIZATION(Int32);
MIRA_PLOT_THRESHOLD_VISUALIZATIONS_SERIALIZATION(Int64);
MIRA_PLOT_THRESHOLD_VISUALIZATIONS_SERIALIZATION(UInt8);
MIRA_PLOT_THRESHOLD_VISUALIZATIONS_SERIALIZATION(UInt16);
MIRA_PLOT_THRESHOLD_VISUALIZATIONS_SERIALIZATION(UInt32);
MIRA_PLOT_THRESHOLD_VISUALIZATIONS_SERIALIZATION(UInt64);

MIRA_PLOT_THRESHOLD_VISUALIZATIONS_SERIALIZATION(Float);
MIRA_PLOT_THRESHOLD_VISUALIZATIONS_SERIALIZATION(Double);
