#!/bin/bash

###############################################################################
# A script which creates a zip file of binaries of the current mira project
###############################################################################

if [ $# != 1 ]; then
	echo "Usage: $0 name"
	exit
fi
name=$1

if [ ! -f CMakeLists.mira ] && [ ! -f mira.root ]; then
	echo "The current directory does not look like a MIRA project."
	exit
fi

###############################################################################
# Create a clean directory structure for the setup

DESTDIR=${PWD}/_setup_
if [ -d ${DESTDIR} ] ; then
	echo "Directory $DESTDIR already exists. Abort."
	exit
fi

rm -rf ${DESTDIR}
mkdir -p ${DESTDIR}

LASTDIR=$(pwd)

###############################################################################
# Create a new external project

mirawizard -e ${name} ${DESTDIR}/${name}

###############################################################################
# Do a 'make install' by all packages in this project

for f in `find . -name "*.package*"` ; do
	cmake \
		-D BUILD_TYPE=Release \
		-D CMAKE_INSTALL_DO_STRIP=1 \
		-D CMAKE_INSTALL_COMPONENT=`basename $f .package`\
		-D CMAKE_INSTALL_PREFIX=${DESTDIR}/${name} \
		-P build/release/cmake_install.cmake
done

cd ${DESTDIR}/${name}

###############################################################################
# Create archive and cleanup

TODAY=`date +%Y-%m-%d`

cd ${DESTDIR}
echo "Creating ${name}_${TODAY}.tgz..."
tar czf ${LASTDIR}/${name}_${TODAY}.tgz ${name}

cd ${LASTDIR}
rm -rf ${DESTDIR}

