/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file MdiAreaTest.C
 *    Manual test for testing the mdi area.
 *
 * @author Erik Einhorn
 * @date   2011/09/11
 */

#include <iostream>

#include <QApplication>
#include <QWidget>
#include <QListWidget>
#include <QVBoxLayout>


#include <rcp/EditorPartArea.h>
#include <rcp/EditorPartWindow.h>

using namespace mira;
int main(int argc, char** argv)
{
	QApplication qapp(argc,argv);

	std::cout << sizeof(QWidget) << std::endl;
	std::cout << sizeof(EditorPartWindow) << std::endl;

	EditorPartArea* a = new EditorPartArea();
	EditorPartWindow* w = new EditorPartWindow(a);
	a->show();
	w->show();
	w->resize(100,100);

	QListWidget* l = new QListWidget(w);
	w->setWidget(l);
	w->setWindowTitle("Test w");


	EditorPartWindow* w2 = new EditorPartWindow(a);
	w2->show();
	w2->resize(150,100);

	QListWidget* l2 = new QListWidget(w2);
	w2->setWidget(l2);
	w2->setWindowTitle("Test w2");


	EditorPartWindow* w3 = new EditorPartWindow(a);
	w3->show();
	w3->resize(150,100);
	w3->setWindowTitle("Test w3");


	EditorPartWindow* w4 = new EditorPartWindow(a);
	w4->show();
	w4->resize(150,100);
	w4->setWindowTitle("Test w4");


	EditorPartWindow* w5 = new EditorPartWindow(a);
	w5->show();
	w5->setWindowTitle("Test w5");
	w5->resize(150,100);

	return qapp.exec();
}
