/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file RectObject.C
 *    .
 *
 * @author Tim Langner
 * @date   2011/08/18
 */

#include <OGRE/OgreSceneManager.h>
#include <OGRE/OgreSceneNode.h>
#include <OGRE/OgreManualObject.h>
#include <OGRE/OgreMaterialManager.h>

#include <visualization/3d/RectObject.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

RectObject::RectObject(Ogre::SceneManager* sceneManager,
                       Ogre::SceneNode* parent) :
	VisualizationObject(sceneManager, parent),
	mColor(Ogre::ColourValue::Black),
	mRect(-1,-1, 2, 2)
{
	mManualObject = mSceneManager->createManualObject("RectObject"+ toString(this));
	mManualObject->setCastShadows(false);
	mNode->attachObject(mManualObject);
	setColor(mColor);
	setupRect();
}

RectObject::~RectObject()
{
	mNode->detachObject(mManualObject);
	mSceneManager->destroyManualObject(mManualObject);
}

void RectObject::setColor(const Ogre::ColourValue& color)
{
	mColor = color;
	setupRect();
}

void RectObject::setRect(const Rect2f& rect)
{
	mRect = rect;
	setupRect();
}

void RectObject::setupRect()
{
	mManualObject->clear();
	mManualObject->estimateVertexCount(5);

	mManualObject->begin("TransparentNoLight", Ogre::RenderOperation::OT_LINE_STRIP);
	Ogre::Vector3 p1(mRect.minCorner.x(), mRect.minCorner.y(), 0);
	Ogre::Vector3 p2(mRect.minCorner.x(), mRect.maxCorner.y(), 0);
	Ogre::Vector3 p3(mRect.maxCorner.x(), mRect.maxCorner.y(), 0);
	Ogre::Vector3 p4(mRect.maxCorner.x(), mRect.minCorner.y(), 0);
	mManualObject->position(p1);
	mManualObject->colour(mColor);
	mManualObject->position(p2);
	mManualObject->colour(mColor);
	mManualObject->position(p3);
	mManualObject->colour(mColor);
	mManualObject->position(p4);
	mManualObject->colour(mColor);
	mManualObject->position(p1);
	mManualObject->colour(mColor);
	mManualObject->end();
}

///////////////////////////////////////////////////////////////////////////////

}
