/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

#include "BasicClasses.h"
#include "CommonTest.h"

#include <serialization/adapters/boost/shared_ptr.hpp>
#include <serialization/Serialization.h>

using namespace mira;

class DummyBase
{
public:
	DummyBase() : a(1), b(2) {}
	virtual ~DummyBase() {}

	template<typename Reflector>
	void reflect(Reflector& r) {
		r.member("a", a, "");
		r.member("b", b, "");
	}

	int a;
	int b;
};

//////////////////////////////////////////////////////////////////////////////

class OtherDummyBase
{
public:
	OtherDummyBase() : x(8), y(9) {}
	virtual ~OtherDummyBase() {}

	template<typename Reflector>
	void reflect(Reflector& r) {
		r.member("x", x, "");
		r.member("y", y, "");
	}

	int x;
	int y;
};

//////////////////////////////////////////////////////////////////////////////

class MultiClass : public DummyBase, public mira::Object
{
	MIRA_OBJECT(MultiClass)

public:

	MultiClass() : c(3) {}

	template<typename Reflector>
	void reflect(Reflector& r) {
		MIRA_REFLECT_BASE(r,DummyBase);
		r.member("c", c, "");
	}

	int c;
};

MIRA_CLASS_SERIALIZATION(MultiClass, mira::Object);

//////////////////////////////////////////////////////////////////////////////

class MultiClass2 : public MultiClass
{
	MIRA_OBJECT(MultiClass2)

public:

	MultiClass2() : d(4) {}

	template<typename Reflector>
	void reflect(Reflector& r){
		MIRA_REFLECT_BASE(r,MultiClass);
		r.member("d", d, "");
	}

	int d;
};

MIRA_CLASS_SERIALIZATION(MultiClass2, MultiClass);

//////////////////////////////////////////////////////////////////////////////

class MultiClass3 : public OtherDummyBase, public MultiClass
{
	MIRA_OBJECT(MultiClass3)

public:

	MultiClass3() : d(4) {}

	template<typename Reflector>
	void reflect(Reflector& r){
		MIRA_REFLECT_BASE(r,OtherDummyBase);
		MIRA_REFLECT_BASE(r,MultiClass);
		r.member("d", d, "");
	}

	int d;
};

MIRA_CLASS_SERIALIZATION(MultiClass3, MultiClass);

//////////////////////////////////////////////////////////////////////////////

class MultiClassUser
{
public:

	MultiClassUser() {
		object = NULL;
		ref = NULL;
		ref2 = NULL;
		object3 = NULL;
		object5 = NULL;
		object6 = NULL;
		ref4 = NULL;
	}

	MultiClassUser(bool) {
		MultiClass* o = new MultiClass;
		object = o;
		ref = o;
		ref2 = o;
		object2.reset(new MultiClass);
		ref3 = object2;
		object3 = new MultiClass2;
		object4.reset(new MultiClass2);
		object5 = new MultiClass3;
		MultiClass3* p = new MultiClass3;
		object6 = p;
		ref4 = p;
	}

	virtual ~MultiClassUser()
	{
		delete object;
		delete object3;
		delete object5;
		delete object6;
	}

	void check() {
		{
			MultiClass* o = dynamic_cast<MultiClass*>(object);
			BOOST_CHECK((void*)o < (void*)object);
			BOOST_CHECK_EQUAL(o->c,3);
		}

		{
			boost::shared_ptr<MultiClass> o = boost::dynamic_pointer_cast<MultiClass>(object2);
			BOOST_CHECK((void*)o.get() < (void*)object2.get());
			BOOST_CHECK_EQUAL(o->c,3);
		}

		{
			BOOST_CHECK_EQUAL(ref,object);
			MultiClass* o = dynamic_cast<MultiClass*>(ref);
			BOOST_CHECK_EQUAL(ref2,o);
			BOOST_CHECK((void*)o < (void*)ref);
			BOOST_CHECK_EQUAL(o->c,3);
		}

		{
			boost::shared_ptr<MultiClass> o = boost::dynamic_pointer_cast<MultiClass>(ref3);
			BOOST_CHECK((void*)o.get() < (void*)ref3.get());
			BOOST_CHECK_EQUAL(o->c,3);
		}

		{
			MultiClass2* o = dynamic_cast<MultiClass2*>(object3);
			BOOST_CHECK_EQUAL(object3->c,3);
			BOOST_CHECK_EQUAL(o->d,4);
		}

		{
			boost::shared_ptr<MultiClass2> o = boost::dynamic_pointer_cast<MultiClass2>(object4);
			BOOST_CHECK_EQUAL(object4->c,3);
			BOOST_CHECK_EQUAL(o->d,4);
		}

		{
			MultiClass3* o = dynamic_cast<MultiClass3*>(object5);
			BOOST_CHECK_EQUAL(o->c,3);
			BOOST_CHECK_EQUAL(o->d,4);
		}

		{
			MultiClass3* o = dynamic_cast<MultiClass3*>(object6);
			MultiClass* o2 = dynamic_cast<MultiClass*>(object6);
			BOOST_CHECK((void*)o < (void*)o2);
			BOOST_CHECK((void*)o2 < (void*)object6);
			BOOST_CHECK_EQUAL(o->c,3);
			BOOST_CHECK_EQUAL(o->d,4);
			BOOST_CHECK_EQUAL(ref4,o2);
		}

	}

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.member("object", object, "");
		r.member("object2", object2, "");
		r.member("ref", ref, "");
		r.member("ref2", ref2, "");
		r.member("ref3", ref3, "");
		r.member("object3", object3, "");
		r.member("object4", object4, "");
		r.member("object5", object5, "");
		r.member("object6", object6, "");
		r.member("ref4", ref4, "");
	}

	mira::Object* object;
	boost::shared_ptr<mira::Object> object2;
	mira::Object* ref;
	MultiClass* ref2;
	boost::shared_ptr<mira::Object> ref3;


	MultiClass* object3;
	boost::shared_ptr<MultiClass> object4;

	MultiClass* object5;
	mira::Object* object6;
	MultiClass3* ref4;

};

//////////////////////////////////////////////////////////////////////////////

BOOST_AUTO_TEST_CASE( TestMultiInheritance )
{
	testAll<MultiClassUser>("MultiInheritance", 1);
}
