/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file SerializationDataTest.C
 *    Test serialization of data types that are not covered in the basic tests.
 *
 * @author Erik Einhorn
 */

#include <boost/test/unit_test.hpp>

#include "CommonTest.h"

#include <serialization/IgnoreMissing.h>
#include <serialization/adapters/boost/optional.hpp>
#include <serialization/adapters/boost/tuple.hpp>
#include <xml/XMLDomReflect.h>

using namespace std;
using namespace mira;

///////////////////////////////////////////////////////////////////////////////

class TestClass
{
public:

	TestClass() {
	}

	// set member to some values
	TestClass(bool) {
		opt1.reset(123);
		opt2.reset();
		guard = 0xABCD;
		tup = boost::make_tuple(12,3.45f,"678");
	}

	// returns true, if the values are as required
	void check() {
		BOOST_CHECK_EQUAL(*opt1, 123);
		BOOST_CHECK_EQUAL((bool)opt2, false);
		BOOST_CHECK_EQUAL(guard, 0xABCD);
		BOOST_CHECK_EQUAL(tup.get<0>(), 12);
		BOOST_CHECK_EQUAL(tup.get<1>(), 3.45f);
		BOOST_CHECK_EQUAL(tup.get<2>(), "678");
	}

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.member("opt1", opt1, "", serialization::IgnoreMissing());
		r.member("opt2", opt2, "", serialization::IgnoreMissing());
		r.member("tup", tup, "");
		r.member("guard", guard, "");
	}

	boost::optional<int> opt1;
	boost::optional<int> opt2;
	boost::tuple<int,float,std::string> tup;
	int guard;
};

//////////////////////////////////////////////////////////////////////////////

BOOST_AUTO_TEST_CASE( MiscDataTest)
{
	testAll<TestClass>("Data",1);
}

///////////////////////////////////////////////////////////////////////////////
