/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file Exception.C
 *    Implementation of Exception.h
 *
 * @author Erik Einhorn, Christian Martin
 * @date   2010/04/01
 */

#include <error/Exception.h>
#include <utils/MakeString.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

const char* Exception::what() const MIRA_NOEXCEPT_OR_NOTHROW
{
	const std::size_t INDENT = 4;
	const char* INDENT_STR = "    ";

	mMessage = "";

	// obtain max width
	std::size_t maxMessageSize = 0;
	for(std::list<Info>::const_iterator i = mInfos.begin();
		i!=mInfos.end(); ++i)
	{
		std::size_t msgSize = i->message.size();

		if(i!=mInfos.begin())
			msgSize+=INDENT;

		if(msgSize > maxMessageSize)
			maxMessageSize = msgSize;
	}

	// append all informations with correct indentation
	for(std::list<Info>::const_iterator i = mInfos.begin();
		i!=mInfos.end(); ++i)
	{
		if(i!=mInfos.begin()) {
			mMessage += std::string("\n") + INDENT_STR;
			mMessage += i->what(maxMessageSize-INDENT);
		} else
			mMessage += i->what(maxMessageSize);

	}

	return mMessage.c_str();
}

std::string Exception::message() const MIRA_NOEXCEPT_OR_NOTHROW
{
	std::string s;
	// append all informations with correct indentation
	for(std::list<Info>::const_iterator i = mInfos.begin(); i!=mInfos.end(); ++i)
	{
		if(i!=mInfos.begin())
			s += ", " + i->message;
		else
			s = i->message;
	}

	return s;
}

///////////////////////////////////////////////////////////////////////////////

std::string Exception::Info::what(std::size_t messageWidth) const
{
	std::string s = message;

	// fill with spaces
	for(std::size_t i=message.size(); i<messageWidth; ++i)
		s += " ";

	if(!file.empty())
		s+= MakeString() << " (" << file << ":" << line << ")";
	return s;
}

///////////////////////////////////////////////////////////////////////////////

}
