/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file UpdateDialog.h
 *    $Dialog for visualizing update plan$.
 *
 * @author Ronny Stricker
 * @date   2012/04/16
 */

#ifndef UPDATEDIALOG_H_
#define UPDATEDIALOG_H_

#include <ui_UpdateDialog.h>

#include <QDialog>
#include <QLabel>
#include <QCheckBox>

#include "core/Package.h"

namespace mira {
//
////////////////////////////////////////////////////////////////////////////////
//
//class PathWidget : public QWidget {
//	Q_OBJECT
//
//public:
//	PathWidget( std::string iName, mira::Path iPath, QWidget* parent );
//
//	void setValid( bool valid )
//	{
//		mValid = valid;
//		updateColor();
//	}
//
//	void setEditable( bool editable );
//
//	virtual ~PathWidget();
//
//public slots:
//	void showPathDialog();
//	void updateColor();
//	void dropPathSelected();
//
//signals:
//	void pathUpdated();
//
//protected:
//	void selectCustom();
//
//public:
//	std::string mPackageName;
//	mira::Path mPath;
//	bool mValid;
//
//	QLabel* label;
//	QComboBox* box;
//	QPushButton* button;
//};

//////////////////////////////////////////////////////////////////////////////

class UpdateDialog : public QDialog, protected Ui::UpdateDialog
 {
     Q_OBJECT

public:
     UpdateDialog( std::vector<std::pair<Package*,Package*> >* updatePlan, QWidget *parent = 0)
     	 : QDialog( parent ), mUpdatePlan( updatePlan )
     {
    	 Ui::UpdateDialog::setupUi(this);

    	 if ( mUpdatePlan ) {
    		 int line = 0;
			 mTblUpdate->setRowCount( mUpdatePlan->size() );
    		 foreach( auto upItem, *mUpdatePlan ) {

    			 QCheckBox* tBox = new QCheckBox();
    			 tBox->setCheckState( Qt::Checked );
    			 mTblUpdate->setCellWidget(line,0, tBox );

    			 QString tToolTip = generateToolTip( upItem.second );

				 QLabel* tLabel = new QLabel( QString::fromStdString( "<b>"+upItem.second->mName+"</b>" ) );
				 tLabel->setToolTip( tToolTip );
				 mTblUpdate->setCellWidget(line,1, tLabel );

				 tLabel = new QLabel( QString::fromStdString( "<b>"+upItem.second->mVersion.str()+"</b>" ) );
				 tLabel->setToolTip( tToolTip );
				 mTblUpdate->setCellWidget(line,2, tLabel );

				 tLabel = new QLabel( QString::fromStdString( Package::getDevelStateString(*upItem.second) ) );
				 tLabel->setToolTip( tToolTip );
				 mTblUpdate->setCellWidget(line,3, tLabel );

				 tToolTip = generateToolTip( upItem.first );

				 tLabel = new QLabel( QString::fromStdString( "<b>"+upItem.first->mVersion.str()+"</b>" ) );
				 tLabel->setToolTip( tToolTip );
				 mTblUpdate->setCellWidget(line,4, tLabel );

				 tLabel = new QLabel( QString::fromStdString( Package::getDevelStateString(*upItem.first) ) );
				 tLabel->setToolTip( tToolTip );
				 mTblUpdate->setCellWidget(line,5, tLabel );

				 ++line;
    		 }

    	 }
    	 mTblUpdate->horizontalHeader()->setResizeMode(0,QHeaderView::ResizeToContents);
    	 mTblUpdate->horizontalHeader()->setResizeMode(1,QHeaderView::Stretch);

    	 for ( int i=2; i<mTblUpdate->columnCount(); ++i )
    		 mTblUpdate->horizontalHeader()->setResizeMode(i,QHeaderView::ResizeToContents);

     }

     virtual ~UpdateDialog()
     {

     }
     
public slots:
	virtual void accept()
	{
		if ( mUpdatePlan && mUpdatePlan->size() > 0 ) {
			auto planIt = mUpdatePlan->end();
			planIt--;
			for( int line = mTblUpdate->rowCount(); line > 0; --line ) {
				QCheckBox* tBox = dynamic_cast<QCheckBox*>( mTblUpdate->cellWidget( line-1, 0 ) );
				assert( tBox );
				if ( tBox->checkState() == Qt::Unchecked ) {
					// remove item from update plan
					mUpdatePlan->erase( mUpdatePlan->begin() +=  (line-1 ) );
				}
			}
		}
		QDialog::accept();
	}

protected:
	QString generateToolTip( Package* package )
	{
		std::string repo = package->mRepos.size() ? *(package->mRepos.begin()) : "";

		std::string tPackageTip = "<b>"+package->mName
				+ "<br><br>changelog:</b> " + package->mChangeLog
				+ "<br><b>repository: </b>" + repo
				+ "<br><b>subpath: </b>" + package->mRepoSubPath;
		return QString::fromStdString( tPackageTip );
	}

protected:
	std::vector<std::pair<Package*,Package*> >* mUpdatePlan;
 };

//////////////////////////////////////////////////////////////////////////////

}

#endif /* UPDATEDIALOG_H_ */
