/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file WorkbenchTest.C
 *    Tests Workbench and all involved classes
 *
 * @author Erik Einhorn
 * @date   2012/03/22
 */

#include <test/QtUnitTest.h>
#include <QLabel>

#include <serialization/Serialization.h>

#include <factory/ManifestAgent.h>

#include <rcp/Workbench.h>
#include <rcp/EditorPartArea.h>

#include <views/PropertyView.h>

using namespace mira;

class EditorDummy : public EditorPart
{
MIRA_META_OBJECT(EditorDummy,
                ("Name", "Dummy")
                ("Description", "Dummy"))

public:
	EditorDummy() :
        mLabel(NULL) {}

protected:

    virtual QWidget* createPartControl()
    {
    	mLabel = new QLabel();
    	mLabel->setAlignment(Qt::AlignCenter);
    	mLabel->setText(tr("No properties available"));
        return mLabel;
    }

private:
    QLabel* mLabel;
};

MIRA_CLASS_SERIALIZATION(EditorDummy, mira::EditorPart);

///////////////////////////////////////////////////////////////////////////////

BOOST_AUTO_TEST_CASE( WorkbenchTest )
{
	// load all manifests
	try {
		loadManifests();
	} catch(Exception& ex) {
		MIRA_LOG(WARNING) << ex.what();
	}

	Workbench workbench;

	Workbench::Perspective* p1 = workbench.addPerspective("Perspective 1");
	Workbench::Perspective* p2 = workbench.addPerspective("Perspective 2");
	Workbench::Perspective* p3 = workbench.addPerspective("Perspective 3");
	workbench.removePerspective(p2);

	workbench.activatePerspective(p1);


	QWidget* view1 = workbench.createPart(ClassFactory::instance().getClassByIdentifier("mira::PropertyView"));
	QWidget* view2 = workbench.createPart(ClassFactory::instance().getClassByIdentifier("mira::PropertyView"));
	// we can only instantiate one view of the same class
	BOOST_CHECK_EQUAL(view1,view2);

	QWidget* editor1 = workbench.createPart(ClassFactory::instance().getClassByIdentifier("EditorDummy"));
	QWidget* editor2 = workbench.createPart(ClassFactory::instance().getClassByIdentifier("EditorDummy"));
	BOOST_CHECK(editor1!=editor2);
	editor1->showMaximized();
	editor2->showMaximized();

	workbench.activatePerspective(p3);

	// back to first perspective (will recreate the above views and editors)
	workbench.activatePerspective(p1);

	// uncomment the following lines to see the gui for debugging and manual testing
	//workbench.show();
	//qApp->exec();
}
