/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file BufferTest.C
 *    Test cases for Buffer.h.
 * @date 2010/11/19
 *
 * @author Erik Einhorn
 */

#include <iostream>
#include <boost/test/unit_test.hpp>

#include <utils/Buffer.h>
#include <utils/Foreach.h>
#include <stream/BinaryStream.h>

using namespace mira;
using namespace std;

BOOST_AUTO_TEST_CASE( testBasicAccess )
{
	Buffer<int> buffer;
	buffer.push_back(5);
	buffer.push_back(8);
	buffer.push_back(10);
	BOOST_CHECK(buffer.size() == 3);
	BOOST_CHECK(buffer.capacity() >= 3);
	BOOST_CHECK(buffer[0] == 5);
	BOOST_CHECK((*buffer.begin()) == 5);
	BOOST_CHECK(buffer.front() == 5);
	BOOST_CHECK(buffer.back() == 10);
}

BOOST_AUTO_TEST_CASE( testStream )
{
	Buffer<int> startBuffer;
	Buffer<uint8> outBuffer;
	Buffer<int> buffer;

	startBuffer.push_back(5);
	startBuffer.push_back(8);
	startBuffer.push_back(10);

	BinaryBufferOstream os(&outBuffer);
	os << startBuffer;

	BinaryBufferIstream is(&outBuffer);
	is >> buffer;

	BOOST_CHECK(buffer.size() == 3);
	BOOST_CHECK(buffer.capacity() >= 3);
	BOOST_CHECK(buffer == startBuffer);
}

BOOST_AUTO_TEST_CASE( testConvert )
{
	std::vector<int> vec;
	vec.push_back(1);
	vec.push_back(2);
	vec.push_back(3);

	// now buffer takes over myvec
	Buffer<int> buffer(std::move(vec));

	BOOST_CHECK(buffer.size() == 3);
	BOOST_CHECK(buffer.capacity() >= 3);
	BOOST_CHECK(vec.size() == 0);
	BOOST_CHECK(vec.capacity() == 0);
	BOOST_CHECK(buffer[0] == 1);
}

