#!/bin/bash

function _miracentercomplete_launch 
{
	local ARG="${COMP_WORDS[COMP_CWORD]}"
	COMPREPLY=()
	# handle program options
	if [[ ${ARG} =~ \-\-.* ]]; then
		# add specific miracenter options
		COMPREPLY=(${COMPREPLY[@]} $(compgen -W "
		--no-workspace
		--default-workspace
		--workspace
		--initial-workspace
		--minimized
		--fontsize
		--no-splash
		--no-statusbar" -- ${ARG}))
		
		# add general framework options
		COMPREPLY=(${COMPREPLY[@]} $(compgen -W "${MIRA_FRAMEWORK_ARGUMENTS}" -- ${ARG}))
 	else
		_miracomplete_pkgandfiles
	fi
}

complete -o default -o nospace -F _miracentercomplete_launch miracenter
