/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file VisualizationPlotHistogramBasic.h
 *    TODO Add description.
 *
 * @author Christian Vollmer
 * @date   2013/06/04
 */

#ifndef _MIRA_VISUALIZATIONPLOTHISTOGRAMBASIC_H_
#define _MIRA_VISUALIZATIONPLOTHISTOGRAMBASIC_H_

#if (QWT_VERSION >= 0x060000)
# include <qwt_point_3d.h>
# include <qwt_compat.h>
#endif

#include <qwt_plot_histogram.h>

#include <serialization/adapters/Qt/QColor>

#include <visualization/VisualizationPlot.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

template<typename T>
class VisualizationPlotHistogramBasic : public VisualizationPlotHistogram
{

public:

	VisualizationPlotHistogramBasic(const std::string& channelName) :
		mName(channelName),
		mHistogram(NULL),
		mColor(Qt::black)
	{
		mChannel.setDataChangedCallback(boost::bind(&VisualizationPlotHistogramBasic::dataChanged, this, _1));
		mChannel.setChannelChangedCallback(boost::bind(&VisualizationPlotHistogramBasic::channelChanged, this));
	}

	virtual ~VisualizationPlotHistogramBasic()
	{
		if (mHistogram)
		{
			mHistogram->detach();
			delete mHistogram;
		}
	}

	template <typename Reflector>
	void reflect(Reflector& r)
	{
		MIRA_REFLECT_BASE(r, VisualizationPlotHistogram);
		channelProperty(r, mName, mChannel, "");
		r.property("Color", mColor,
		           setter<QColor>(&VisualizationPlotHistogramBasic::setColor, this),
		           "The color of the histogram", Qt::black);
	}

	virtual void setupScene(IVisualizationPlotSite* site)
	{
		mHistogram = createHistogram();
	}

	virtual void clear()
	{
		if (!mHistogram)
			return;
		mHistogram->detach();
		delete mHistogram;
		mHistogram = createHistogram();
	}

	virtual DataConnection getDataConnection() { return DataConnection(mChannel); }

	virtual void channelChanged()
	{
		clear();
	}

	virtual void dataChanged(ChannelRead<T>& data) {}

	virtual void setEnabled(bool enabled)
	{
		VisualizationPlotHistogram::setEnabled(enabled);
		if (mHistogram)
			mHistogram->setVisible(isEnabled());
	}

	void setColor(const QColor& color)
	{
		mColor = color;
		if (mHistogram)
			mHistogram->setBrush(QBrush(mColor));
	}

	virtual QwtPlotItem* getPlotItem()
	{
		return mHistogram;
	}

	QwtPlotHistogram* createHistogram()
	{
		mHistogram = new QwtPlotHistogram(mChannel.getID().c_str());
		mHistogram->setBrush(QBrush(mColor));
		mHistogram->setVisible(VisualizationPlotHistogram::isEnabled());
		mHistogram->attach(VisualizationPlotHistogram::getSite()->getPlot());
		return mHistogram;
	}

protected:
	std::string mName;
	ChannelProperty<T> mChannel;
	QwtPlotHistogram* mHistogram;
	QColor mColor;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif 
