###############################################################################
# ZLib
###############################################################################

IF(WIN32)
	# On Windows, download zlib

	if(CMAKE_SIZEOF_VOID_P EQUAL 8)
		set(ZLIB_URL "http://www.mira-project.org/downloads/3rdparty/bin-win64/zlib-1.2.5.win64.zip" )
	else()
		set(ZLIB_URL "http://www.mira-project.org/downloads/3rdparty/bin-win32/zlib-1.2.5.win32.zip" )
	endif()

	MIRA_EXTERNAL_PROJECT(ZLib
		URL ${ZLIB_URL}

		PREFIX       ${MIRA_ROOT_DIR}/external/zlib
		STAMP_DIR    ${MIRA_ROOT_DIR}/external/zlib/cmake
		TMP_DIR      ${MIRA_ROOT_DIR}/external/zlib/cmake
		DOWNLOAD_DIR ${MIRA_ROOT_DIR}/external/zlib
		SOURCE_DIR   ${MIRA_ROOT_DIR}/external/zlib/zlib
		BINARY_DIR   ${MIRA_ROOT_DIR}/external/zlib/zlib
		CONFIGURE_COMMAND "" # no configure step
		BUILD_COMMAND     "" # no build step
		INSTALL_COMMAND   "" # no install step
	)

	SET(ZLIB_INCLUDE_DIRS
		"${MIRA_ROOT_DIR}/external/zlib/zlib/include"
	)

	SET(ZLIB_LIBRARY_DIRS
		"${MIRA_ROOT_DIR}/external/zlib/zlib/lib"
	)

	SET(ZLIB_LIBRARIES
		"zdll"
	)

	MIRA_DIST_LIBRARY_EX(ZLib ${MIRA_ROOT_DIR}/external/zlib/zlib/zlib1.dll)

	MIRA_INSTALL(
		DIRECTORY ${MIRA_ROOT_DIR}/external/zlib/zlib/include
		DESTINATION external/zlib/zlib
		PACKAGE external
		FILES_MATCHING
		PATTERN "*"
		PATTERN ".svn" EXCLUDE
	)

	MIRA_INSTALL(
		DIRECTORY ${MIRA_ROOT_DIR}/external/zlib/zlib/lib
		DESTINATION .
		PACKAGE external
		FILES_MATCHING
		PATTERN "*.lib"
	)

	MIRA_INSTALL(
		FILES ${MIRA_ROOT_DIR}/external/zlib/zlib/zlib1.dll
		DESTINATION bin
		PACKAGE external
	)

ELSE(WIN32)
	# On Linux, zlib is part of the standard includes

	SET(ZLIB_INCLUDE_DIRS "")
	SET(ZLIB_LIBRARY_DIRS "")
	SET(ZLIB_LIBRARIES    "z")

ENDIF(WIN32)

###############################################################################

IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "ZLIB")
	MESSAGE(STATUS "   incdir = " ${ZLIB_INCLUDE_DIRS})
	MESSAGE(STATUS "   libdir = " ${ZLIB_LIBRARY_DIRS})
	MESSAGE(STATUS "   libs   = " ${ZLIB_LIBRARIES})
ENDIF (CMAKE_VERBOSE_MAKEFILE)
