/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file TestChannelSynchronizer.C
 *
 * @author Tim Langner
 * @date   2010/09/16
 */

#include <fw/Unit.h>
#include <filter/ChannelSynchronizer.h>

namespace mira { namespace fw {

///////////////////////////////////////////////////////////////////////////////

/// Publishes int channel
class TestChannelSynchronizer : public MicroUnit
{
	/// Register at class factory
	MIRA_OBJECT(TestChannelSynchronizer)
public:

	TestChannelSynchronizer() : MicroUnit()
	{
	}

//	/// Reflect method for serialization and services
//	template<typename Reflector>
//	void reflect(Reflector& r)
//	{
//		// call base class reflect
//		MIRA_REFLECT_BASE(r, Unit);
//		// publish interface ICountSetable
//		r.interface("ICountSetable");
//		// publish our setCounter message
//		r.method("setCounter", &TestIntPublisherUnit::setCounter, this,
//		         "sets the internal counter to the specified value");
//	}

	/// Overwritten from MicroUnit. Gets called once on startup
	virtual void initialize()
	{
		sub();

//		std::cout << "start waiting for data 2" << std::endl;
//		mSynchronizer.waitForData();
//		std::cout << "start waiting for data 3" << std::endl;
//		mSynchronizer3.waitForData();
//		std::cout << "finished waiting for data" << std::endl;

		publishService(*this);
	}

	void callback2( ChannelRead<int> a, ChannelRead<int> b ) {
		MIRA_LOG(NOTICE) << "Callback2";
	}

	void callback3( ChannelRead<int> a, ChannelRead<int> b, ChannelRead<int> c ) {
		MIRA_LOG(NOTICE) << "Callback3";
	}

	void sub()
	{
//		mSynchronizer.subscribe(
//			*this,
//			"int1",
//			"int2",
//			boost::bind(
//					&TestChannelSynchronizer::callback2,
//					this, _1, _2), Duration::seconds(3));

		mSynchronizer3.subscribe(
			*this,
			"int1",
			"int2",
			"int3",
			boost::bind(
					&TestChannelSynchronizer::callback3,
					this, _1, _2,_3), Duration::seconds(4));
	}

	void unsub()
	{
//		mSynchronizer.unsubscribe(*this);
		mSynchronizer3.unsubscribe(*this);
	}

	template <typename Reflector>
	void reflect( Reflector& r )
	{
		r.method("unsub", &TestChannelSynchronizer::unsub, this, "unsubscribe from channels");
		r.method("sub", &TestChannelSynchronizer::sub, this, "subscribe to channels");
	}

protected:
	ChannelSynchronizer<int,int> mSynchronizer;
	ChannelSynchronizer3<int,int,int> mSynchronizer3;
};

///////////////////////////////////////////////////////////////////////////////

}}

/// Tell class factory that we are derived from MicroUnit
MIRA_CLASS_SERIALIZATION( mira::fw::TestChannelSynchronizer, mira::MicroUnit );
