/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file CmdLinePromptProvider.h
 *    $short description$.
 *
 * @author Ronny Stricker
 * @date   2012/02/28
 */

#ifndef CMDLINEPROMPTPROVIDER_H_
#define CMDLINEPROMPTPROVIDER_H_

#include <iostream>

#include "core/PromptProvider.h"

namespace mira {

//////////////////////////////////////////////////////////////////////////////

class CmdLinePromptProvider : public PromptProvider {

public:
	virtual ~CmdLinePromptProvider() {}

	virtual bool getLogin( Credential& credential )
	{
		using namespace std;
		cout << "login for repository " << credential.realm << endl;
		cout << "user: ";
		getline( cin, credential.user );
		cout << "password:";
		console::enableEcho( false );
		getline( cin, credential.password );
		console::enableEcho( true );
		cout << endl;
		return true;
	}

	virtual AcceptValue acceptServerCertificate( ServerCertificate const& certificate )
	{
		using namespace std;
		cout << "Do you trust the server certificate from " << certificate.hostname << "?\n";
		cout << "Fingerprint: " << certificate.fingerprint << "\n";
		string decision;
		while (decision != "y" && decision != "n" && decision != "a") {
			cout << "(y)es (n)o (a)llways" << endl;
			getline( cin, decision );
		}
		if ( decision == "a" )
			return Always;
		else if ( decision == "y" )
			return Temporary;
		return Reject;
	}

	virtual void showErrorMessage( std::string const& message )
	{
		std::cout << message << std::endl;
	}

	virtual bool showYesNoErrorMessage( std::string const& message )
	{
		using namespace std;
		cout << message << std::endl;
		string decision;
		while (decision != "y" && decision != "n") {
			cout << "(y)es (n)o" << endl;
			getline( cin, decision );
		}
		return decision == "y";
	}
};

//////////////////////////////////////////////////////////////////////////////

}

#endif


