

SET( SVN_COMMAND_PATH "" )

IF(WIN32)
	FIND_PROGRAM(SVN_COMMAND NAMES svn)
	MESSAGE( "svn command: ${SVN_COMMAND}" )

	GET_FILENAME_COMPONENT(SVN_COMMAND_PATH ${SVN_COMMAND} PATH)
	MESSAGE( "svn bin path: ${SVN_COMMAND_PATH}" )

	SET( LIBNAMES "libsvn_client-1;libsvn_subr-1;libapr-1;libaprutil-1;xml" )
	
ELSE()
	SET( LIBNAMES "svn_client-1;svn_subr-1;apr-1;aprutil-1" )
ENDIF()

###############################################
# Try to find libraries

SET( SUBVERSION_LIBRARY_DIRS )

foreach( LIBNAME ${LIBNAMES} )
	FIND_LIBRARY( LIB_${LIBNAME} NAMES "${LIBNAME}" PATHS "/usr/lib" "${SVN_COMMAND_PATH}/../lib" PATH_SUFFIXES "apr" "apr-util")
	GET_FILENAME_COMPONENT(LIB_${LIBNAME}_PATH ${LIB_${LIBNAME}} PATH)
	IF (${LIB_${LIBNAME}} MATCHES ".*NOTFOUND" )
		MESSAGE(FATAL_ERROR "CANNOT FIND SUBVERSION DEVEL / APR DEVEL because library \"${LIBNAME}\" cannot be found.")
	ENDIF()
	SET( SUBVERSION_LIBRARY_DIRS ${SUBVERSION_LIBRARY_DIRS} ${LIB_${LIBNAME}_PATH} )
endforeach()

###############################################
# Try to find include files

SET( SUBVERSION_INCLUDE_DIRS )
SET( FILENAMES "svn_client.h;apr.h;apr_xlate.h" )

foreach( FILENAME ${FILENAMES} )
	FIND_PATH( PATH_${FILENAME} NAMES "${FILENAME}" PATHS "${SVN_COMMAND_PATH}/../include" PATH_SUFFIXES "subversion" "subversion-1" "apr" "apr-1" "apr-1.0" "apr-util")
	IF (${PATH_${FILENAME}} MATCHES ".*NOTFOUND" )
		MESSAGE(FATAL_ERROR "CANNOT FIND SUBVERSION DEVEL / APR DEVEL because include file \"${FILENAME}\" cannot be found.")
	ENDIF()
	SET( SUBVERSION_INCLUDE_DIRS ${SUBVERSION_INCLUDE_DIRS} ${PATH_${FILENAME}} )
endforeach()

IF(WIN32)
	SET( SUBVERSION_LIBRARIES "${LIB_libsvn_client-1}" "${LIB_libsvn_subr-1}" "${LIB_libapr-1}" "${LIB_libaprutil-1}" "${LIB_xml}" )
ELSE()
	SET( SUBVERSION_LIBRARIES "${LIB_svn_client-1}" "${LIB_svn_subr-1}" "${LIB_apr-1}" "${LIB_aprutil-1}" )
ENDIF()
