###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Updates the "InstallerBuildStatus.txt" file
#
# This cmake script file needs the following variables to be defined:
#
#   MIRA_INSTALLERBUILD_PACKAGE      Name of the package
#   MIRA_INSTALLERBUILD_APIVERSION   The new API version
#   MIRA_INSTALLERBUILD_VERSION      The new version
#   MIRA_INSTALLERBUILD_BUILDNR      The new build number
#
#   MIRA_INSTALLERBUILD_PATH         The path to InstallerBuildStatus
#
# Author: Christian Martin
#
###############################################################################

file(READ "${MIRA_INSTALLERBUILD_PATH}" oldBuildStatus)
file(WRITE "${MIRA_INSTALLERBUILD_PATH}.new")

foreach(package_BuildStatus ${oldBuildStatus})
	string(STRIP ${package_BuildStatus} package_BuildStatus)

	separate_arguments(package_BuildStatus)
	list(LENGTH package_BuildStatus listLen)

	if(listLen EQUAL 8)
		list(GET package_BuildStatus 0 packageName)
		list(GET package_BuildStatus 1 packageAPIVersion)
		list(GET package_BuildStatus 2 packageVersion)
		list(GET package_BuildStatus 3 packageBuildNr)
		list(GET package_BuildStatus 4 packageFlag)
		list(GET package_BuildStatus 5 newPackageAPIVersion)
		list(GET package_BuildStatus 6 newPackageVersion)
		list(GET package_BuildStatus 7 newPackageBuildNr)

		if("${packageName}" STREQUAL "${MIRA_INSTALLERBUILD_PACKAGE}")
			file(APPEND "${MIRA_INSTALLERBUILD_PATH}.new"
			     "${packageName} ${MIRA_INSTALLERBUILD_APIVERSION} ${MIRA_INSTALLERBUILD_VERSION} ${MIRA_INSTALLERBUILD_BUILDNR} false ${newPackageAPIVersion} ${newPackageVersion} ${newPackageBuildNr};\n")
		else()
			file(APPEND "${MIRA_INSTALLERBUILD_PATH}.new"
			     "${packageName} ${packageAPIVersion} ${packageVersion} ${packageBuildNr} ${packageFlag} ${newPackageAPIVersion} ${newPackageVersion} ${newPackageBuildNr};\n")
		endif()

	endif()

endforeach(package_BuildStatus)

file(RENAME "${MIRA_INSTALLERBUILD_PATH}.new" "${MIRA_INSTALLERBUILD_PATH}")
