/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file CommunicationPreparer.C
 *    Prepare plugin to handle communication tags.
 *
 * @author Tim Langner
 * @date   2013/05/15
 */

#include <fw/Framework.h>
#include <fw/RemoteModule.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * Prepare plugin used to resolve <communication> tags in XML documents
 * Order is 200.
 */
class CommunicationTagPreparer : public ConfigurationPreparePlugin
{
	MIRA_OBJECT(CommunicationTagPreparer)
public:

	virtual void prepareDocument(XMLDom& xml);
	virtual int getOrder() const { return 200; }
};

void CommunicationTagPreparer::prepareDocument(XMLDom& xml)
{
	if (!MIRA_FW.getRemoteModule())
		return;
	XMLDom::iterator remoteNode = xml.root().begin("communication");
	if ( remoteNode != xml.root().end() )
	{
		if(MIRA_FW.isStarted())
			MIRA_LOG(WARNING) << "Ignoring 'communication' settings in '"
				<< xml.uri() << "' since remote framework is already running.";
		else {
			XMLDeserializer xmlDS(remoteNode);
			xmlDS.deserializeFromNode("communication", *MIRA_FW.getRemoteModule());
		}
		XMLDom::iterator tmp = remoteNode;
		++remoteNode;
		tmp.remove();
		while(remoteNode != xml.root().end())
		{
			MIRA_LOG(WARNING) << "Ignoring multiple 'communication' settings in '"
				<< xml.uri() << "' (line " << remoteNode.line() << ").";
			XMLDom::iterator tmp = remoteNode;
			++remoteNode;
			tmp.remove();
		}
	}
}

///////////////////////////////////////////////////////////////////////////////

} // namespace

MIRA_CLASS_REGISTER(mira::CommunicationTagPreparer, mira::ConfigurationPreparePlugin)

