/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file LerpTest.C
 *    Test for linear interpolation.
 *
 * @author Erik Einhorn
 * @date   2012/02/13
 */


#include <iostream>

#include <boost/test/unit_test.hpp>
#if BOOST_VERSION >= 107100
#include <boost/test/tools/floating_point_comparison.hpp>
#else
#include <boost/test/floating_point_comparison.hpp>
#endif

#include <math/Lerp.h>

using namespace std;
using namespace mira;

BOOST_AUTO_TEST_CASE( LerpTest )
{
	Eigen::Rotation2Df r1( pi<float>()*0.25f);
	Eigen::Rotation2Df r2(-pi<float>()*0.25f);
	Eigen::Rotation2Df rr1 = lerp(r1,r2,0.5f);
	BOOST_CHECK_SMALL(rr1.angle(), 0.01f);

	Eigen::Rotation2Df r3(deg2rad(91.0f));
	Eigen::Rotation2Df r4(-deg2rad(91.0f));
	Eigen::Rotation2Df rr2 = lerp(r3,r4,0.5f);
	// result can be -180 or 180 degree
	BOOST_CHECK_SMALL(fabs(rr2.angle())-deg2rad(180.0f), 0.0001f);

	Eigen::Rotation2Df r5(deg2rad(89.0f));
	Eigen::Rotation2Df r6(-deg2rad(89.0f));
	Eigen::Rotation2Df rr3 = lerp(r5,r6,0.5f);
	BOOST_CHECK_SMALL(rr3.angle(),deg2rad(0.0001f));

	Degreef deg1( 315.0f);
	Degreef deg2(  45.0f);
	Degreef deg = lerp(deg1,deg2,0.5f);
	BOOST_CHECK_SMALL(deg.value(), 0.01f);

	SignedDegreef sdeg1(-45.0f);
	SignedDegreef sdeg2( 45.0f);
	SignedDegreef sdeg = lerp(sdeg1,sdeg2,0.5f);
	BOOST_CHECK_SMALL(sdeg.value(), 0.01f);


	Radianf rad1( pi<float>()*1.75f);
	Radianf rad2( pi<float>()*0.25f);
	Radianf rad = lerp(rad1,rad2,0.5f);
	BOOST_CHECK_SMALL(rad.value(), 0.01f);


	SignedRadianf srad1(-pi<float>()*0.25f);
	SignedRadianf srad2( pi<float>()*0.25f);
	SignedRadianf srad = lerp(srad1,srad2,0.5f);
	BOOST_CHECK_SMALL(srad.value(), 0.01f);

}
