/*
 * Copyright (C) 2014 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file FramePublisherView.h
 *    View plugin for miracenter for modifying frames dynamically.
 *
 * @author Erik Einhorn
 * @date   2014/04/03
 */

#ifndef _MIRA_FramePublisherVIEW_H_
#define _MIRA_FramePublisherVIEW_H_

#include <QComboBox>
#include <QFormLayout>
#include <QDoubleSpinBox>

#include <fw/Framework.h>
#include <rcp/ViewPart.h>
#include <views/PropertyViewPage.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class FramePublisherView : public ViewPart
{
MIRA_META_OBJECT(FramePublisherView,
				("Name", "Frame Publisher")
				("Category", "General")
				("Description", "Modify and publish frames manually"))
Q_OBJECT

public:
	FramePublisherView();
	virtual ~FramePublisherView();

	template <typename Reflector>
	void reflect(Reflector& r)
	{
		MIRA_REFLECT_BASE(r, ViewPart);
	}

protected:

	virtual QWidget* createPartControl();

private:

	class UI;
	UI* ui;
};

//////////////////////////////////////////////////////////////////////////////

class FramePublisherView::UI : public QWidget
{
	Q_OBJECT
public:
	UI(FramePublisherView* parent);

public slots:

	void updateControls();
	void updateFrames();
	void updateFrame();

public:

	Authority authority;

private:

	void setEdits(float x, float y, float z, float yaw, float pitch, float roll,
	              bool enableX, bool enableY, bool enableZ,
	              bool enableYaw, bool enablePitch, bool enableRoll);	
	void blockEditSignals(bool block);

	FramePublisherView* mParent;
	QFormLayout* mLayout;

	QComboBox* mSelectFrame;
	QDoubleSpinBox* mSbX;
	QDoubleSpinBox* mSbY;
	QDoubleSpinBox* mSbZ;
	QDoubleSpinBox* mSbYaw;
	QDoubleSpinBox* mSbPitch;
	QDoubleSpinBox* mSbRoll;

};

///////////////////////////////////////////////////////////////////////////////

}

#endif 
