###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Checks for MMX, SSE and SSE2 support and enables the correspoding compiler
# flags if available. Additionally sets HAVE_MMX, HAVE_SSE and HAVE_SSE2
# to TRUE or FALSE, depending if the support is available.
#
# Set enivronment variables NO_MMX, NO_SSE or NO_SSE2 to disable usage
# of MMX, SSE, etc.
#
# Platform: currently Unix/Linux only (since /proc/cpuinfo is checked)
#
###############################################################################

IF(UNIX)

	#find MMX, SSE, SSE2
	EXEC_PROGRAM(grep
		ARGS -e mmx /proc/cpuinfo
		OUTPUT_VARIABLE CPUFLAGS
	)

	# check for NO_MMX, NO_SSE and NO_SSE2 environment variables
	SET(NO_MMX  $ENV{NO_MMX})
	SET(NO_SSE  $ENV{NO_SSE})
	SET(NO_SSE2 $ENV{NO_SSE2})

	SET(HAVE_MMX  FALSE)
	SET(HAVE_SSE  FALSE)
	SET(HAVE_SSE2 FALSE)

	SET(ADDITIONAL_CXX_FLAGS "")

	# MMX
	string(REGEX MATCH "mmx" CPUFLAGS_MATCH ${CPUFLAGS})
	IF(CPUFLAGS_MATCH AND NOT NO_MMX)
		SET(HAVE_MMX TRUE)
		SET(ADDITIONAL_CXX_FLAGS "${ADDITIONAL_CXX_FLAGS} -mmmx" )
	ENDIF()
	
	# SSE
	string(REGEX MATCH "sse" CPUFLAGS_MATCH ${CPUFLAGS})
	IF(CPUFLAGS_MATCH AND NOT NO_SSE)
		SET(HAVE_SSE TRUE)
		SET(ADDITIONAL_CXX_FLAGS "${ADDITIONAL_CXX_FLAGS} -msse -mfpmath=sse" )
	ENDIF()

	# SSE2
	string(REGEX MATCH "sse2" CPUFLAGS_MATCH ${CPUFLAGS})
	IF(CPUFLAGS_MATCH AND NOT NO_SSE2)
		SET(HAVE_SSE2 TRUE)
		SET(ADDITIONAL_CXX_FLAGS "${ADDITIONAL_CXX_FLAGS} -msse2")
	ENDIF()

	################
	# set additional debug flags (explicitly set optimize level to 0 and add gdb debug symbols)
	SET(CMAKE_CXX_FLAGS_DEBUG   "${CMAKE_CXX_FLAGS_DEBUG}   ${ADDITIONAL_CXX_FLAGS}")
	SET(CMAKE_CXX_FLAGS_RELEASE "${CMAKE_CXX_FLAGS_RELEASE} ${ADDITIONAL_CXX_FLAGS}")
	SET(CMAKE_CXX_FLAGS_TEST    "${CMAKE_CXX_FLAGS_TEST}    ${ADDITIONAL_CXX_FLAGS}")

ENDIF(UNIX)
