/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file QtUtils.h
 *    Declaration of helper functions related to Qt.
 *
 * @author Tim Langner
 * @date   2011/02/06
 */

#ifndef _MIRA_QTUTILS_H_
#define _MIRA_QTUTILS_H_

#include <image/Img.h>
#include <transform/RigidTransform.h>

#include <widgets/GuiWidgetsExports.h>

#include <QString>
#include <QFileDialog>

class QImage;
class QGraphicsItem;
class QFileDialog;
class QWidget;

namespace mira { namespace QtUtils {

///////////////////////////////////////////////////////////////////////////////

/**
 *  Convert an image to QImage. Min and max are used for scaling in
 *  images with > 8bit color values.
 */
MIRA_GUI_WIDGETS_EXPORT QImage toQImage(const Img<>& img, double s_min, double s_max);

/**
 * Convert a QImage to an image.
 */
MIRA_GUI_WIDGETS_EXPORT void fromQImage(const QImage& qimage, Img<>& oImg);

/**
 * Applies a transform (translation and rotation) to a graphics scene item.
 */
MIRA_GUI_WIDGETS_EXPORT void setTransform(QGraphicsItem* item, const RigidTransform2f& t);

/**
 * Enforce the use of non-native FileDialog-methods to prevent platform depending behavior differences
 */
MIRA_GUI_WIDGETS_EXPORT QString getOpenFileName(QWidget* parent = NULL,
                                                const QString& caption = QString(),
                                                const QString& dir = QString(),
                                                const QString& filter = QString(),
                                                QString* selectedFilter = NULL,
                                                QFileDialog::Options options = QFileDialog::DontUseNativeDialog);

/**
 * Enforce the use of non-native FileDialog-methods to prevent platform depending behavior differences
 * @param[in] enforceExtension If a non-empty list is provided as argument, the method will make sure
 *                             one of these extensions is selected, replacing the extension entered by the user
 *                             with the first element in the list if necessary.
 */
MIRA_GUI_WIDGETS_EXPORT QString getSaveFileName(QWidget* parent = NULL,
                                                const QString& caption = QString(),
                                                const QString& dir = QString(),
                                                const QString& filter = QString(),
                                                QString* selectedFilter = NULL,
                                                QFileDialog::Options options = QFileDialog::DontUseNativeDialog,
                                                const QStringList& enforceExtension = QStringList());
/**
 * Enforce the use of non-native FileDialog-methods to prevent platform depending behavior differences
 */
MIRA_GUI_WIDGETS_EXPORT QString getExistingDirectory(QWidget* parent = NULL,
                                                     const QString& caption = QString(),
                                                     const QString& dir = QString(),
                                                     QFileDialog::Options options = QFileDialog::DontUseNativeDialog | QFileDialog::ShowDirsOnly);

///////////////////////////////////////////////////////////////////////////////

}}

#endif
