/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file VisualizationTool2D.h
 *    Declaration of VisualizationTool2D.
 *
 * @author Tim Langner
 * @date   2013/07/08
 */

#ifndef _MIRA_VISUALIZATIONTOOL2D_H_
#define _MIRA_VISUALIZATIONTOOL2D_H_

#include <visualization/Visualization2D.h>
#include <visualization/VisualizationTool.h>

class QGraphicsItem;

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class MIRA_GUI_VISUALIZATION_EXPORT VisualizationTool2D : public VisualizationTool
{
	MIRA_OBJECT(VisualizationTool2D)

public:
	// force alignment, since we contain a rigid transform, that contains eigen
	// matrices, ...
	EIGEN_MAKE_ALIGNED_OPERATOR_NEW

	VisualizationTool2D();
	virtual ~VisualizationTool2D();

public:

	template <typename Reflector>
	void reflect(Reflector& r)
	{
		MIRA_REFLECT_BASE(r, VisualizationTool);
	}

public:

	/**
	 * Is called by the visualization view when the tool is attached.
	 * The tool should initialize itself.
	 */
	virtual void init(IVisualizationSite* site);

	/**
	 * Returns a pointer to the IVisualizationSite interface that was set
	 * in the init() method.
	 * Or returns NULL, if init() was not yet called.
	 */
	virtual IVisualization2DSite* getSite();

public:

	virtual void activate();

	virtual void deactivate();

protected:

	virtual void update(Duration dt);

	virtual void setupScene(IVisualization2DSite* site) {
		QGraphicsScene* mgr = site->getSceneManager();
		mItem = setupScene(mgr);
	}

	/**
	 * Implement this method to setup the scene.
	 * The graphics item you create must be returned.
	 */
	virtual QGraphicsItem* setupScene(QGraphicsScene* mgr) = 0;

protected:

	QGraphicsItem* mItem;
	RigidTransform2f mTransform;

private:

	IVisualization2DSite* mSite;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif
