/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

#include <fw/MicroUnit.h>

namespace mira { namespace test {

///////////////////////////////////////////////////////////////////////////////

class Ticket434Service : public MicroUnit
{
	MIRA_OBJECT(Ticket434Service)
public:
	Ticket434Service()  {}

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.method("foo",&Ticket434Service::foo, this, "");
	}

	virtual void initialize()
	{
		std::cout << "Ticket434Service::initialize()" << std::endl;
		MIRA_SLEEP(20);
		publishService(*this);
		std::cout << "Ticket434Service::initialize() done" << std::endl;
		MIRA_SLEEP(20);
	}

	int foo(int param) {
		return param+1;
	}
};


class Ticket434ServiceCaller : public MicroUnit
{
	MIRA_OBJECT(Ticket434ServiceCaller)
public:
	Ticket434ServiceCaller()  {}

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.member("Services", mServices, "");
	}

	virtual void initialize()
	{
		std::cout << "Ticket434ServiceCaller::initialize()" << std::endl;
		int sum=0;
		for(int i=0; i<10000; ++i)
		{
			foreach(const std::string& s, mServices)
			{
				try {
				RPCFuture<int> res = callService<int>(s,"foo",i);
				sum+=res.get();;
				} catch(Exception& ex) {
					std::cout << ex.what()<<std::endl;
				}
			}
		}
		std::cout << "Ticket434ServiceCaller::initialize() done: " << sum << std::endl;
	}

	std::list<std::string> mServices;
};

}}

///////////////////////////////////////////////////////////////////////////////

MIRA_CLASS_SERIALIZATION(mira::test::Ticket434Service, mira::MicroUnit);
MIRA_CLASS_SERIALIZATION(mira::test::Ticket434ServiceCaller, mira::MicroUnit);

