###############################################################################
# checks for sqlite3 and the corresponding headers
###############################################################################

IF(UNIX)
	FIND_PATH(SQLITE_INCLUDE_DIRS NAMES sqlite3.h)

	FIND_LIBRARY(SQLITE_LIBRARY_PATH NAMES sqlite3)
	GET_FILENAME_COMPONENT(SQLITE_LIBRARY_DIRS ${SQLITE_LIBRARY_PATH} PATH)

	SET(HAVE_SQLITE OFF)

	IF(NOT SQLITE_LIBRARY_DIRS STREQUAL SQLITE_LIBRARY_DIRS-NOTFOUND)
		IF(NOT ${SQLITE_INCLUDE_DIRS} STREQUAL SQLITE_INCLUDE_DIRS-NOTFOUND)
			SET(HAVE_SQLITE ON)
		ENDIF(NOT ${SQLITE_INCLUDE_DIRS} STREQUAL SQLITE_INCLUDE_DIRS-NOTFOUND)
	ENDIF(NOT SQLITE_LIBRARY_DIRS STREQUAL SQLITE_LIBRARY_DIRS-NOTFOUND)

	IF(NOT HAVE_SQLITE)
		MESSAGE(FATAL_ERROR "Could not find sqlite3 library")
	ENDIF(NOT HAVE_SQLITE)

	SET(SQLITE_LIBRARIES "sqlite3")
ENDIF(UNIX)

###############################################################################

IF(WIN32)
	MIRA_EXTERNAL_PROJECT(SQLite
		URL http://www.mira-project.org/downloads/3rdparty/bin-win32/SQLite-3.7.3.zip

		PREFIX       ${MIRA_ROOT_DIR}/external/sqlite
		STAMP_DIR    ${MIRA_ROOT_DIR}/external/sqlite/cmake
		TMP_DIR      ${MIRA_ROOT_DIR}/external/sqlite/cmake
		DOWNLOAD_DIR ${MIRA_ROOT_DIR}/external/sqlite
		SOURCE_DIR   ${MIRA_ROOT_DIR}/external/sqlite/sqlite
		BINARY_DIR   ${MIRA_ROOT_DIR}/external/sqlite/sqlite

		CONFIGURE_COMMAND "" # no configure step
		#BUILD_COMMAND     cmake -GUnix\ Makefiles . && make
		BUILD_COMMAND     cmake -GNMake\ Makefiles -DCMAKE_BUILD_TYPE=Release . && nmake
		INSTALL_COMMAND   "" # no install step
	)

	SET(HAVE_SQLITE ON)

	# Set the SQLite include dir
	SET(SQLITE_INCLUDE_DIRS "${MIRA_ROOT_DIR}/external/sqlite/sqlite")
	SET(SQLITE_LIBRARY_DIRS "${MIRA_ROOT_DIR}/external/sqlite/sqlite")
	SET(SQLITE_LIBRARIES    "sqlite3.lib")

	MIRA_INSTALL(
		FILES ${MIRA_ROOT_DIR}/external/sqlite/sqlite/sqlite3.h
		${MIRA_ROOT_DIR}/external/sqlite/sqlite/sqlite3ext.h
		DESTINATION external/sqlite/sqlite
		PACKAGE external
	)

	MIRA_INSTALL(
		FILES ${MIRA_ROOT_DIR}/external/sqlite/sqlite/sqlite3.lib
		DESTINATION lib
		PACKAGE external
	)

ENDIF(WIN32)

###############################################################################

IF (CMAKE_VERBOSE_MAKEFILE)
	MESSAGE(STATUS "SQLITE")
	MESSAGE(STATUS "    have   = " ${HAVE_SQLITE})
	MESSAGE(STATUS "    incdir = " ${SQLITE_INCLUDE_DIRS})
	MESSAGE(STATUS "    libdir = " ${SQLITE_LIBRARY_DIRS})
	MESSAGE(STATUS "    libs   = " ${SQLITE_LIBRARIES})	
ENDIF (CMAKE_VERBOSE_MAKEFILE)

###############################################################################
