###############################################################################
# Copyright (C) 2012 by
#   MetraLabs GmbH (MLAB), GERMANY
# and
#   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
# All rights reserved.
#
# Contact: info@mira-project.org
#
# Commercial Usage:
#   Licensees holding valid commercial licenses may use this file in
#   accordance with the commercial license agreement provided with the
#   software or, alternatively, in accordance with the terms contained in
#   a written agreement between you and MLAB or NICR.
#
# GNU General Public License Usage:
#   Alternatively, this file may be used under the terms of the GNU
#   General Public License version 3.0 as published by the Free Software
#   Foundation and appearing in the file LICENSE.GPL3 included in the
#   packaging of this file. Please review the following information to
#   ensure the GNU General Public License version 3.0 requirements will be
#   met: http://www.gnu.org/copyleft/gpl.html.
#   Alternatively you may (at your option) use any later version of the GNU
#   General Public License if such license has been publicly approved by
#   MLAB and NICR (or its successors, if any).
#
# IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
# INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
# THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
# "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
# BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
# ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
# PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
#
###############################################################################
#
# Provides MIRA_ADD_DOCUMENTATION macro for invoking doxygen to create API
# documentations.
#
# Usage:
#     MIRA_ADD_DOCUMENTATION(TargetName
#         [DIRS          <the directories used for creating the docs>]
#         [RESOURCES     <additional resource files that are copied to the documentations dir>]
#         [DEPENDS       <dependencies to other built documentations>]
#         [EXAMPLE_DIRS  <optional directories for including example files>]
#         [IMAGE_DIRS    <optional directories for including image files>]
#     )
#
# Author: Erik Einhorn
#
###############################################################################

# the target root directory for the documentations
SET(MIRA_DOC_PATH "${CMAKE_SOURCE_DIR}/doc")

###############################################################################

FIND_PACKAGE(Doxygen)

INCLUDE(CMakeParseArguments)
INCLUDE(RelpathFn)

###############################################################################

# create a global doc target that allows us to call "make doc" to create all
# documentations
ADD_CUSTOM_TARGET(doc
		COMMAND ${CMAKE_COMMAND} -D MIRA_ROOT_DIR=${MIRA_ROOT_DIR} -P ${CMAKE_CURRENT_LIST_DIR}/GenerateDocIndex.cmake)

IF(DOXYGEN_FOUND)

MACRO(MIRA_ADD_DOCUMENTATION target)

	CMAKE_PARSE_ARGUMENTS(arg
		# options:
		""
		# one-value arguments:
		"OUTPUT"
		# multi-value arguments:
		"DIRS;DEPENDS;RESOURCES;EXAMPLE_DIRS;IMAGE_DIRS"
		${ARGN})

	IF (NOT arg_OUTPUT)
		RELPATH(arg_OUTPUT ${CMAKE_SOURCE_DIR} ${CMAKE_CURRENT_SOURCE_DIR})
	ENDIF()

	SET(DOC_PATH "${MIRA_DOC_PATH}/${arg_OUTPUT}")
	FILE(MAKE_DIRECTORY "${DOC_PATH}")

	# turn arg_DIRS list into a space separated string
	SET(DOXYGEN_INPUT "")
	FOREACH(dir ${arg_DIRS})
		SET(DOXYGEN_INPUT "${DOXYGEN_INPUT} ${dir}")
	ENDFOREACH()

	# turn arg_EXAMPLE_DIRS list into a space separated string
	SET(DOXYGEN_EXAMPLE_PATH "")
	FOREACH(dir ${arg_EXAMPLE_DIRS})
		SET(DOXYGEN_EXAMPLE_PATH "${DOXYGEN_EXAMPLE_PATH} ${dir}")
	ENDFOREACH()

	# turn arg_IMAGE_DIRS list into a space separated string
	SET(DOXYGEN_IMAGE_PATH "")
	FOREACH(dir ${arg_IMAGE_DIRS})
		SET(DOXYGEN_IMAGE_PATH "${DOXYGEN_IMAGE_PATH} ${dir}")
	ENDFOREACH()


	# turn arg_RESOURCES list into a space separated string
	# add some files per default (must be in one single line separated by spaces!
	#SET(DOXYGEN_EXTRA_FILES "${MIRA_ROOT_DIR}/make/documentation/MiraStyle.css ${MIRA_ROOT_DIR}/make/documentation/img/attention.png ${MIRA_ROOT_DIR}/make/documentation/img/DeveloperSmall.png ${MIRA_ROOT_DIR}/make/documentation/img/EndUserSmall.png ${MIRA_ROOT_DIR}/make/documentation/img/AppDesignerSmall.png")
	#FOREACH(dir ${arg_RESOURCES})
	#	SET(DOXYGEN_EXTRA_FILES "${DOXYGEN_EXTRA_FILES} ${dir}")
	#ENDFOREACH()

	LIST(APPEND arg_RESOURCES
	  ${MIRA_ROOT_DIR}/make/documentation/MiraStyle.css
	  ${MIRA_ROOT_DIR}/make/documentation/img/attention.png
	  ${MIRA_ROOT_DIR}/make/documentation/img/DeveloperSmall.png
	  ${MIRA_ROOT_DIR}/make/documentation/img/EndUserSmall.png
	  ${MIRA_ROOT_DIR}/make/documentation/img/AppDesignerSmall.png)

	SET(DOXYGEN_OUTPUT "${DOC_PATH}")
	SET(DOXYGEN_TAGFILE "${DOC_PATH}/${target}.tag")
	# create an empty dummy tag file (needed by other documentation parts that are searching that file)
	FILE(WRITE ${DOXYGEN_TAGFILE} "")

	# Ensure, that the tag is in the index, so that other documentations parts
	# can really find it during the cmake step.
	MIRA_ADD_DOCTAG_TO_INDEX(${target} ${DOC_PATH}/${target}.tag)

	# collect documentation dependencies 
	LIST(APPEND arg_DEPENDS "MIRA") # add MIRA as default dependency
	FOREACH(dep ${arg_DEPENDS})
		# only add dependencies to targets that really exist (needed for external projects)
		IF(TARGET ${dep}_doc)
			LIST(APPEND DOC_DEPENDS "${dep}_doc")
		ENDIF()
	ENDFOREACH()

	# tag files
	# collect the tag files for each of the above dependencies
	SET(DOXYGEN_REFFERED_TAGFILES "")
	FOREACH(dep ${arg_DEPENDS})
		IF(NOT ${target} STREQUAL "${dep}") # avoid self dependencies
			#find the tag file for the dependency
			MIRA_FIND_DOCTAG(${dep})
			IF ( NOT DOCTAG_${dep}_FOUND )
				MESSAGE(WARNING "Can not find tag file '${dep}.tag' that is needed to build documentation for ${target}.")
			ELSE()
				FILE(RELATIVE_PATH rpath_full ${DOC_PATH} ${DOCTAG_${dep}_PATH})
				GET_FILENAME_COMPONENT(rpath ${rpath_full} PATH)
				SET(DOXYGEN_REFFERED_TAGFILES "\"${DOCTAG_${dep}_PATH}=${rpath}\" \\ \n ${DOXYGEN_REFFERED_TAGFILES}")
				# MESSAGE(STATUS "-- ${DOXYGEN_REFFERED_TAGFILES}")
			ENDIF()
		ENDIF()
	ENDFOREACH()

	# Take the Doxyfile.template and fill in all variables that we have
	# set above
	CONFIGURE_FILE(${MIRA_ROOT_DIR}/make/documentation/Doxyfile.template
	               ${DOC_PATH}/Doxyfile) 

	# create install targets for all resources
	FOREACH(res ${arg_RESOURCES})
		if(NOT IS_ABSOLUTE ${res})
			SET(res_src ${CMAKE_CURRENT_SOURCE_DIR}/${res})
		else()
			SET(res_src ${res})
		endif()
		GET_FILENAME_COMPONENT(res_name ${res_src} NAME)
		SET(res_dest ${DOC_PATH}${res_name})

		#MESSAGE(STATUS "!!!! ${res_src} -> ${res_dest}")
		ADD_CUSTOM_COMMAND(
			OUTPUT ${res_dest}
			COMMAND ${CMAKE_COMMAND} -E copy ${res_src} ${res_dest}
			DEPENDS ${res_src}
			COMMENT "Copying ${res_src} -> ${res_dest}"
		)
		LIST(APPEND DOC_DEPENDS "${res_dest}")
		#EXECUTE_PROCESS(COMMAND ${CMAKE_COMMAND} -E copy ${CMAKE_CURRENT_SOURCE_DIR}/${res} ${DOC_PATH})
	ENDFOREACH()

	#MESSAGE(STATUS "!!!! ${DOC_DEPENDS}")
	ADD_CUSTOM_TARGET(${target}_doc
		COMMAND ${DOXYGEN_EXECUTABLE} "${DOC_PATH}/Doxyfile"
		COMMAND ${CMAKE_COMMAND} -DFILE=${DOC_PATH}/doxygen.css -DMIRASTYLE=${MIRA_ROOT_DIR}/make/documentation/MiraStyle.css -P ${MIRA_ROOT_DIR}/make/documentation/PatchDoxygenCSS.cmake
		WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}
		DEPENDS ${DOC_DEPENDS}
		COMMENT "Generating documentation in ${CMAKE_CURRENT_SOURCE_DIR}" VERBATIM
	)

	# add this documentation target to the global doc target
	ADD_DEPENDENCIES(doc ${target}_doc)

ENDMACRO(MIRA_ADD_DOCUMENTATION)

ELSE(DOXYGEN_FOUND)

# create dummy macro, if no doxygen is present
MACRO(MIRA_ADD_DOCUMENTATION target)
ENDMACRO(MIRA_ADD_DOCUMENTATION)

ENDIF(DOXYGEN_FOUND)
