/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file QtUnit.C
 *    Implementation of QtUnit.h.
 *
 * @author Erik Einhorn
 * @date   2011/09/29
 */

#include <fw/QtUnit.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

static const int defaultInterval = 50;

QtUnit::QtUnit(Flags flags) :
	MicroUnit(flags | NO_MAIN_THREAD)
{
	connect(QCoreApplication::instance(), SIGNAL(aboutToQuit()), this, SLOT(onAboutToQuit()));
}

QtUnit::~QtUnit()
{
}

void QtUnit::onAboutToQuit()
{
	// Normally QApplication terminates before the Framework goes down
	// so the timer that processes our handlers will no longer work
	// First: signal destruction
	destruct();
	// Spin until we have processed all final handlers
	while(spin(Duration::milliseconds(0)));
}

void QtUnit::start()
{
	start(defaultInterval);
}

void QtUnit::start(int interval)
{
	MicroUnit::start();
	mCycleTimer = startTimer(interval);
}

void QtUnit::timerEvent(QTimerEvent* event)
{
	// do not process timer (and therefore do not execute initialize(), process() or any handler
	// functions before application (main event loop) is executed to prevent blocking
	// qt even loop
	if (!MIRA_FW.isInExec())
		return;
	if(event->timerId()==mCycleTimer)
		// avoid blocking Qt thread by using max wait time 0 here
		spin(Duration::milliseconds(0));
	QObject::timerEvent(event);
}

///////////////////////////////////////////////////////////////////////////////

}

MIRA_CLASS_REGISTER(mira::QtUnit, mira::MicroUnit);

