/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file VisualizationTextTraceBasic.h
 *    A base class for simple text trace visualizations.
 *
 * @author Tim Langner
 * @date   2014/06/26
 */

#ifndef _MIRA_VISUALIZATIONTEXTTRACEBASIC_H_
#define _MIRA_VISUALIZATIONTEXTTRACEBASIC_H_

#include <QTreeWidget>

#include <visualization/VisualizationTextTrace.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

template<typename T>
class VisualizationTextTraceBasic : public VisualizationTextTrace
{
public:

	VisualizationTextTraceBasic(const std::string& channelName) :
		mName(channelName),
		mItem(NULL)
	{
		mChannel.setDataIntervalChangedCallback(boost::bind(&VisualizationTextTraceBasic::dataIntervalChanged, this, _1));
		mChannel.setChannelChangedCallback(boost::bind(&VisualizationTextTraceBasic::channelChanged, this));
	}

	virtual ~VisualizationTextTraceBasic()
	{
		if (getSite())
			getSite()->destroyItem(mItem);
	}

	template <typename Reflector>
	void reflect(Reflector& r)
	{
		VisualizationTextTrace::reflect(r);
		channelProperty(r, mName, mChannel, "");
	}

	virtual void setupScene(IVisualizationTextTraceSite* site)
	{
		mItem = site->addItem();
		mItem->setName(mChannel.getID());
	}

	virtual DataConnection getDataConnection() { return DataConnection(mChannel); }

	virtual void channelChanged()
	{
		try {
			this->setName(mChannel.getID());
		}
		catch (XRuntime&) {}
		if (!mItem)
			return;
		mItem->setName(mChannel.getID());
	}

	virtual void dataChanged(ChannelRead<T> data) {}

	virtual void dataIntervalChanged(ChannelReadInterval<T> data)
	{
		typename ChannelReadInterval<T>::const_iterator it = data.begin();
		for (; it !=data.end(); it++) {
			ChannelRead<T> r = it;
			dataChanged(r);
		}
	}

	virtual IVisualizationTextTraceItem* getItem() { return mItem; }

protected:

	std::string mName;
	ChannelProperty<T> mChannel;
	IVisualizationTextTraceItem* mItem;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif 
