/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file VisualizationControl.h
 *    Declaration of the VisualizationControl.
 *
 * @author Erik Einhorn
 * @date   2010/12/17
 */

#ifndef _MIRA_VISUALIZATIONCONSTROL_H_
#define _MIRA_VISUALIZATIONCONSTROL_H_

#include <serialization/adapters/Qt/QAction>
#include <rcp/PageViewPart.h>
#include <views/GuiViewsExports.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * View part for managing (adding, removing and editing properties) visualizations
 * of the currently focused visualization view. The visualization view must implement
 * the VisualizationControlPage adapter for its visualizations and properties to be
 * shown in this view upon activation.
 */
class MIRA_GUI_VIEWS_EXPORT VisualizationControl : public PageViewPart
{
MIRA_META_OBJECT(VisualizationControl,
                ("Name", "Visualization Control")
                ("Description", "View for adding, removing and editing visualizations")
                ("Category"   , "Visualization"))

public:
	VisualizationControl();
	virtual ~VisualizationControl();

	virtual Qt::DockWidgetArea getDefaultDockArea() const {
		return Qt::LeftDockWidgetArea;
	}

public:

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		PageViewPart::reflect(r);
		r.member("HideFilterBarAct",
		         getter<bool>(boost::bind(actionGetter, mHideFilterBarAct)),
		         setter<bool>(boost::bind(actionSetter, mHideFilterBarAct, _1)),
		         "", false);
	}

protected: // implementation of PageViewPart

	virtual QWidget* createPartControl();

	virtual QWidget* createDefaultPage();
	virtual QWidget* createPage(IWorkbenchPart* part);

private:

	QAction* mHideFilterBarAct;
	QWidget* mDefaultPage;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif
