/*
 * Copyright (C) by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */


#ifndef Q_MOC_RUN
#include <boost/test/unit_test.hpp>
#endif

#include "CommonTest.h"

//////////////////////////////////////////////////////////////////////////////

class Base
{
public:
	Base() : a(0), b(0) {}
	Base(bool) : a(1), b(2) {}

	void check() const {
		BOOST_CHECK_EQUAL(a, 1);
		BOOST_CHECK_EQUAL(b, 2);
	}

	int a;
	int b;
};

//////////////////////////////////////////////////////////////////////////////

class Derived : public Base
{

public:
	Derived() : c(0) {}
	Derived(bool) : Base(true), c(3) {}

	void check() const {
		Base::check();
		BOOST_CHECK_EQUAL(c, 3);
	}

	int c;
};

//////////////////////////////////////////////////////////////////////////////

// add non-intrusive reflect() methods for Base and Derived
template<typename Reflector>
void reflect(Reflector& r, Base& base)
{
//	test will fail if we want to use these versions!

//	int v = r.version(2);
//	if (v == 1) {
		r.member("a", base.a, "");
		r.member("b", base.b, "");
//	}
//	if (v == 2) {
//		r.member("a2", base.a, "");
//		r.member("b2", base.b, "");
//	}
}

template<typename Reflector>
void reflect(Reflector& r, Derived& derived)
{
	MIRA_REFLECT_BASE_NONINTRUSIVE(r, Base, derived);
//	r.version(1);
	r.member("c", derived.c, "");
}

//////////////////////////////////////////////////////////////////////////////

BOOST_AUTO_TEST_CASE( TestNonIntrusiveDerived )
{
	testAll<Derived>("NonIntrusiveDerived", 1);
}
