/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file LogView.h
 *    A view, that shows the log messages.
 *
 * @author Tim Langner
 * @date   2011/06/28
 */

#ifndef _MIRA_LOGVIEW_H_
#define _MIRA_LOGVIEW_H_

#include <QCheckBox>
#include <QComboBox>
#include <QPushButton>
#include <QTreeWidget>

#include <error/Logging.h>
#include <rcp/ViewPart.h>

#include <fw/Framework.h>

#include <widgets/LineEditClear.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class LogView;

class LogViewSink : public LogSink 
{
public:
	LogViewSink(LogView* iView = NULL) :
		mView(iView) {}

	virtual void consume(const LogRecord& record);

protected:
	LogView* mView;
};

///////////////////////////////////////////////////////////////////////////////

class LogView : public ViewPart
{
MIRA_META_OBJECT(LogView,
                ("Category", "Information")
                ("Name", "LogView")
                ("Description", "View for showing log messages"))
public:
	/// The constructor.
	LogView();

	/// The destructor.
	virtual ~LogView();

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.member("Namespace", nsName, "", "");
		r.member("ClassName", className, "", "");
		r.member("ThreadID", threadID, "", "");
		r.member("Severity", severity, "", TRACE);
	}

	virtual Qt::DockWidgetArea getDefaultDockArea() const {
		return Qt::BottomDockWidgetArea;
	}

protected:
	virtual QWidget* createPartControl();

public:
	std::string nsName;
	std::string className;
	std::string threadID;
	SeverityLevel severity;

	boost::shared_ptr<LogViewSink> sink;
	class UI;
	UI* ui;
};

///////////////////////////////////////////////////////////////////////////////

class LogView::UI : public QWidget
{
	Q_OBJECT
public:

	UI(QWidget* parent);

protected:
	virtual void customEvent(QEvent* event);

public slots:

	void changeFilter();
	void severityChanged(int index);
	void globalChanged(bool global);
	void clearClicked();

public:

	QTreeWidget* logWidget;
	LineEditClear* nsEdit;
	LineEditClear* classEdit;
	LineEditClear* threadEdit;
	QComboBox* severityBox;
	QCheckBox* globalBox;
	QPushButton* clearButton;
	QPushButton* pauseButton;
	LogView* view;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif
