/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file CaptureView.h
 *    Description.
 *
 * @author Erik Einhorn
 * @date   12.01.2011
 */

#ifndef _MIRA_CAPTUREVIEW_H_
#define _MIRA_CAPTUREVIEW_H_

#include <fw/Framework.h>
#include <rcp/ViewPart.h>
#include <rcp/EditorPart.h>
#include <rcp/PartListener.h>

#include <widgets/PropertyEditor.h>
#include <video/AbstractVideoOutput.h>

#include <QTimer>

#include <QGridLayout>
#include <QHBoxLayout>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QToolButton>
#include <QWidget>
#include <QSpinBox>
#include <QComboBox>
#include <QTabWidget>
#include <QSplitter>

#include <QGLWidget>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class CaptureView : public ViewPart, public IPartListener
{
MIRA_META_OBJECT(CaptureView,
                ("Name", "Capture")
                ("Description", "Allows to capture the content of an editor or the whole workspace"))
public:
	CaptureView();
	virtual ~CaptureView();

public: // implementation of IPartListener
	virtual void editorActivated(IWorkbenchPart* part);
	virtual void editorClosed(IWorkbenchPart* part);
	virtual void viewActivated(IWorkbenchPart* part) {}
	virtual void viewClosed(IWorkbenchPart* part) {}

protected:
	virtual QWidget* createPartControl();
private:
	class UI;
	UI* ui;
};


class CaptureView::UI : public QWidget
{
	Q_OBJECT
public:

	UI(CaptureView* iView);
	void setupUi();

public slots:

	void choosePath();

	void captureNext();
	void capture(bool on);

private slots:

	void outputChanged(int);
	void videoFormatChanged(int);

public:

	CaptureView* view;

public:
	Authority authority;
	Channel<Img<>> imageChannel;
	QSplitter* splitter;
	QGridLayout* mainLayout;
	QComboBox* cbSource;
	QComboBox* cbFormat;
	QComboBox* cbOutput;
	QComboBox* cbVideoFormat;
	PropertyEditor* mPropertyEditor;
	video::AbstractVideoOutputPtr videoOut;
	QSpinBox* sbFramerate;
	QSpinBox* sbImageQuality;
	QLineEdit* leOutputPath;
	QSpinBox* sbOutputFrame;
	QToolButton* btOutputSelect;
	QPushButton* btCapture;
	QTabWidget* settingsTabWidget;
	QWidget* imageSettingsTab;
	QWidget* videoSettingsTab;

	EditorPart* editorToCapture;

	QTimer captureTimer;
};


///////////////////////////////////////////////////////////////////////////////

}


#endif
