/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file MeshObject.h
 *    Declaration of MeshObject.
 *
 * @author Tim Langner
 * @date   2011/01/04
 */

#ifndef _MIRA_MESHOBJECT_H_
#define _MIRA_MESHOBJECT_H_

#include <string>

#ifndef Q_MOC_RUN
#include <OGRE/OgreMaterial.h>
#endif

#include <visualization/3d/VisualizationObject.h>

namespace Ogre {
	class Entity;
	class ManualObject;
}

namespace mira {

//////////////////////////////////////////////////////////////////////////////

class MIRA_GUI_VISUALIZATION_EXPORT MeshObject : public VisualizationObject
{
public:

	/**
	 * Constructs a mesh object that renders the specified mesh resource
	 * as child of 'parent'.
	 */
	MeshObject(const std::string& mesh, Ogre::SceneManager* sceneManager,
	           Ogre::SceneNode* parent=NULL);

	MeshObject(const std::string& mesh, Ogre::MaterialPtr material,
	           Ogre::SceneManager* sceneManager, Ogre::SceneNode* parent=NULL);

	virtual ~MeshObject();

	/**
	 * Sets the base color of the meshs material.
	 * @note This method sets the materials Scene Blending to Ogre::SBT_TRANSPARENT_ALPHA
	 *       if the alpha channel is not 0, otherwise to Ogre::SBT_REPLACE.
	 */
	virtual void setColor(const Ogre::ColourValue& color);

	/**
	 * Returns the default material that is created and set in the constructor.
	 */
	Ogre::MaterialPtr getMaterial() { return mMaterial; }

	/**
	 * Returns the entity that is created and set in the constructor.
	 */
	Ogre::Entity* getEntity() { return mEntity; }

protected:

	void create(const std::string& mesh);

	Ogre::Entity* mEntity;
	Ogre::MaterialPtr mMaterial;
	bool mOwnsMaterial;
};

//////////////////////////////////////////////////////////////////////////////

}

#endif
