/*
 * Copyright (C) 2018 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file TestAuthority.h
 *    Test authority for PublisherSourceTest/TapeSourceTest
 *
 * @author Christof Schröter
 * @date   2018/08/10
 */

#include <boost/test/unit_test.hpp>
#include <fw/Framework.h>

using namespace mira;

///////////////////////////////////////////////////////////////////////////////

// An authority checking channel data, specific to the test case
// (in this case, check incoming int numbers for consecutive values)

template <int Limit, bool UseLimit = true>
class TestAuthority : public mira::Authority
{
public:
	TestAuthority() : Authority("/", "TestAuthority"), lastValue(-1), isFinished(false)
	{
		subscribe<int>("Int", &TestAuthority::checkInt);
		publishService(*this);
	}

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.method("signalFinished", &TestAuthority::signalFinished, this,
		         "External signal that we are finished (e.g. called by tape player)");
	}

	bool finished() { return isFinished; }

protected:

	void signalFinished() { isFinished = true; }

	void checkInt(ChannelRead<int> read)
	{
		// here is the data test logic

		BOOST_CHECK(*read == lastValue+1);
		lastValue = *read;
		std::cout << "\r" << lastValue;
		if (UseLimit)
			std::cout << "/" << Limit;
		std::cout.flush();

		if (UseLimit)
			isFinished = (lastValue >= Limit);
	}

protected:

	int lastValue;
	bool isFinished;
};
