/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file InstallOverviewDialog.h
 *    GUI for install overview.
 *
 * @author Ronny Stricker
 * @date   2011/10/06
 */

#ifndef INSTALLOVERVIEWDIALOG_H_
#define INSTALLOVERVIEWDIALOG_H_

#include <ui_InstallOverviewDialog.h>

#include <QDialog>
#include <QComboBox>

#include "core/Database.h"

class QLabel;
class QPushButton;
class QCheckBox;

namespace mira {

class PathWidget;

///////////////////////////////////////////////////////////////////////////////

class MiraTblItem : public QWidget {
	Q_OBJECT
public:
	MiraTblItem( Package const* package, Database::Action const& action,
			Database* database, QWidget* parent = 0 );

	bool enabled() const;

	bool valid() const;

	mira::Path const& path() const;

	const Package* getPackage() const { return(mPackage); }

signals:
	void pathChanged();
	void activationChanged(bool);

protected:
	const Package* mPackage;
	QCheckBox* mChecked;
	PathWidget* mPathWidget;
};

///////////////////////////////////////////////////////////////////////////////

class PathWidget : public QWidget {
	Q_OBJECT

public:
	PathWidget( std::string iName, mira::Path iPath, bool changeable, QWidget* parent );

	void setValid( bool valid )
	{
		mValid = valid;
		updateColor();
	}

	void setEditable( bool editable );

	virtual ~PathWidget();

public slots:
	void showPathDialog();
	void updateColor();
	void dropPathSelected();

signals:
	void pathUpdated();

protected:
	void selectCustom();

public:
	std::string mPackageName;
	mira::Path mPath;
	bool mValid;
	bool mChangeable;

	QLabel* label;
	QComboBox* box;
	QPushButton* button;
};

///////////////////////////////////////////////////////////////////////////////

class InstallOverviewDialog : public QDialog, protected Ui::InstallOverviewDialog
{
	Q_OBJECT

public:
	InstallOverviewDialog( std::vector<Package*> const uninstallSequence,
	                       std::vector<Package*> const installSequence,
	                       Database* database, QWidget *parent = 0);
	virtual ~InstallOverviewDialog();

public slots:
	virtual void accept();
	void updateOKButton();

protected:
	Database* mDatabase;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif
