/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file TagTableModel.h
 *    TODO Add description.
 *
 * @author ronny
 * @date   16.08.2011
 */

#ifndef _MIRA_TAGTABLEMODEL_H_
#define _MIRA_TAGTABLEMODEL_H_

#include <QAbstractTableModel>
#include <QFont>
#include <QColor>
#include <QBrush>

#include "core/Database.h"

namespace mira {

///////////////////////////////////////////////////////////////////////////////

class TagTableModel : public QAbstractTableModel
 {
     Q_OBJECT
 public:
     TagTableModel(Database* database, QObject *parent = 0 )
     	 : QAbstractTableModel( parent ), mDatabase( database )
     {

     }

     int rowCount(const QModelIndex &parent = QModelIndex()) const
     {
    	 return mDatabase->tags.size();
     }

     int columnCount(const QModelIndex &parent = QModelIndex()) const
     {
    	 return 2;
     }
     
     QVariant headerData ( int section, Qt::Orientation orientation, int role = Qt::DisplayRole ) const
     {
		if (orientation == Qt::Horizontal && role == Qt::DisplayRole) {
			switch ( section ) {
			case 0: return QVariant("Tag");break;
			case 1: return QVariant("Count");break;
			}
		}
		return QVariant();
     }

     QVariant data(const QModelIndex &index, int role = Qt::DisplayRole) const
     {
		if (!index.isValid())
    		return QVariant();

		if ( index.row() < int(mDatabase->tags.size()) ) {
    	
			if ( role == Qt::DisplayRole ) {
			 	typedef std::map<std::string,int> mapType;
			 	mapType::iterator tIt = mDatabase->tags.begin();
			 	for( int row = index.row(); row>0; --row )
			 		tIt++;
			 	switch( index.column() ) {
			 		case 0 : return QString::fromStdString( tIt->first );
			 					break;
					case 1 : return QString::number( tIt->second ); break;
		 		}
			} else
			if ( role == Qt::FontRole ) {
				typedef std::map<std::string,int> mapType;
			 	mapType::iterator tIt = mDatabase->tags.begin();
			 	for( int row = index.row(); row>0; --row )
			 		tIt++;
			 		
				int weight = QFont::Light;
				// use the 
				if ( tIt->second == 2 ) weight = QFont::Normal;
				if ( tIt->second == 3 ) weight = QFont::DemiBold;
				if ( tIt->second == 4 ) weight = QFont::Bold;
				if ( tIt->second >= 5 ) weight = QFont::Black;
				return QFont("Arial",11,QFont::DemiBold);			
			} else
			if ( role == Qt::ForegroundRole ) {
				typedef std::map<std::string,int> mapType;
			 	mapType::iterator tIt = mDatabase->tags.begin();
			 	for( int row = index.row(); row>0; --row )
			 		tIt++;
				return QBrush( QColor(tIt->second < 6 ? (tIt->second-1)*50 : 255,0,0) );
			}
		 }
    	 return QVariant();
     }

     void beginReset()
     {
    	 beginResetModel();
     }

     void endReset()
     {
    	 endResetModel();
     }

 protected:
     Database* mDatabase;
 };

///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
