/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file VisualizationPlotCurveView.h
 *    Visualization view for plotting data as a curve using Qwt.
 *
 * @author Tim Langner, Christian Vollmer
 * @date   2013/06/04
 */

#ifndef _MIRA_VISUALIZATIONPLOTCURVEVIEW_H_
#define _MIRA_VISUALIZATIONPLOTCURVEVIEW_H_

#include <qwt_plot_zoomer.h>

#include <views/VisualizationPlotView.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * 2D curve plot view of a scene that may contain different visualization objects which
 * show the actual content of the scene.
 */
class VisualizationPlotCurveView : public VisualizationPlotView
{
MIRA_META_OBJECT(VisualizationPlotCurveView,
				("Name", "Curve Plot View")
				("Description", "View for plotting visualizations")
				("Category"   , "Visualization")
				("Visualization", "mira::VisualizationPlotCurve"))

public:
	VisualizationPlotCurveView();

	virtual ~VisualizationPlotCurveView()
	{
	}

public:

	template <typename Reflector>
	void reflect(Reflector& r)
	{
		VisualizationPlotView::reflect(r);
	}

public: // implementation of VisualizationView

	virtual void updateAxes();

	virtual const Class& supportedVisualizationClass() const;

	virtual const Class& defaultVisualizationClass() const;

private:

	class UI;

	/**
	 * Overwrite this method in derived classes if you have a derived UI class.
	 */
	virtual VisualizationPlotView::UI* createUI();

private:
	friend class UI;

private:
	virtual void populateDefaultVisualizations();

};

///////////////////////////////////////////////////////////////////////////////

class VisualizationPlotCurveView::UI : public VisualizationPlotView::UI
{
	Q_OBJECT
public:

	UI(VisualizationPlotCurveView* parent);

	virtual ~UI()
	{
	}

protected:

	virtual void populatePopupMenu(QMenu& menu);
	virtual void onPopupMenuAction(QAction* action);

	void saveAsCSV();

public slots:

#if (QWT_VERSION >= 0x060000)
	void zoomed(const QRectF &rect);
#else
	void zoomed(const QwtDoubleRect &rect);
#endif

protected:

	QwtPlotZoomer* zoomer;
};

///////////////////////////////////////////////////////////////////////////////

}

#endif 
