/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file DockingTask.h
 *    Task for specifying a goal for docking
 *
 * @author Erik Einhorn
 * @date   2012/02/17
 */

#ifndef _MIRA_DOCKINGTASK_H_
#define _MIRA_DOCKINGTASK_H_

#include <transform/Pose.h>

#include <navigation/Task.h>

namespace mira { namespace navigation {

///////////////////////////////////////////////////////////////////////////////

/**
 * Task for docking to a given position with a given orientation.
 */
class MIRA_NAVIGATION_EXPORT DockingTask : public SubTask
{
	MIRA_OBJECT(DockingTask);
public:

	EIGEN_MAKE_ALIGNED_OPERATOR_NEW

	/// Creates a task with both tolerances 0.
	DockingTask() {}

	/**
	 * @brief Creates a task with given pose and a tolerance
	 * @param[in] p The requested pose.
	 * @param[in] t The requested tolerance.
	 * @param[in] g The frame of the goal
	 */
	DockingTask(const Pose2& p, const Pose2& t, const std::string& g) :
		pose(p),
		tolerance(t),
		goalFrame(g)
	{}

	/// The reflect method.
	template<typename Reflector>
	void reflect(Reflector& r)
	{
		SubTask::reflect(r);
		r.property("Pose", pose, "Position and orientation");
		r.property("Tolerance", tolerance, "The tolerance for docking.");
		r.property("GoalFrame", goalFrame, "The frame of the goal.");
	}

public:
	/// The requested pose.
	Pose2 pose;

	/// The requested tolerance.
	Pose2 tolerance;

	/// Frame of the goal
	std::string goalFrame;
};

///////////////////////////////////////////////////////////////////////////////

}}

#endif
