/*
 * Copyright (C) 2018 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file ChannelPromoteByTypenameTestUnits3.C
 *    Test units for channel promotion by runtime typename.
 *
 * @author Christof Schröter
 * @date   2018/08/29
 */

#include <fw/Unit.h>
#include <factory/Factory.h>

#include <fw/ChannelPromoteByTypenameRegistration.h>

#include "ChannelPromoteByTypenameTest.h"

using namespace mira;

namespace mira { namespace fw { namespace channel_promote_test { namespace ns3 {

///////////////////////////////////////////////////////////////////////////////

/**
 * Test unit publishing channels
 */
class TestPublisher : public MicroUnit
{
	MIRA_OBJECT(TestPublisher)

protected:

	virtual void initialize();

	void onSignal(ChannelRead<bool> data);
	void postData();

private:

	Channel<Time> mTimeChannel;
	Channel<int> mIntChannel;
	Channel<float> mFloatChannel;
	Channel<String> mStringChannel;
	Channel<char> mCharChannel;
	Channel<double> mDoubleChannel;
};

///////////////////////////////////////////////////////////////////////////////

void TestPublisher::initialize()
{
	mTimeChannel = publish<Time>("Time");
	mIntChannel = publish<int>("Int");
	mFloatChannel = publish<float>("Float");
	mStringChannel = publish<String>("String");
	mCharChannel = publish<char>("Char");
	mDoubleChannel = publish<double>("Double");

	subscribe<bool>("/Signal", &TestPublisher::onSignal, this);
}

void TestPublisher::onSignal(ChannelRead<bool> data)
{
	postData();
}

void TestPublisher::postData()
{
	mTimeChannel.post(Time());
	mIntChannel.post(0);
	mFloatChannel.post(0.f);
	mStringChannel.post(String());
	mCharChannel.post('0');
	mDoubleChannel.post(0.);
}

///////////////////////////////////////////////////////////////////////////////

/**
 * Test unit subscribing channels
 */
class TestSubscriber : public MicroUnit
{
	MIRA_OBJECT(TestSubscriber)

protected:

	virtual void initialize();

private:

	Channel<void> mTimeChannel;
	Channel<void> mIntChannel;
	Channel<void> mFloatChannel;
	Channel<void> mStringChannel;
	Channel<void> mCharChannel;
	Channel<void> mDoubleChannel;
};

///////////////////////////////////////////////////////////////////////////////

void TestSubscriber::initialize()
{
	mTimeChannel = subscribe<void>("Time");
	mIntChannel = subscribe<void>("Int");
	mFloatChannel = subscribe<void>("Float");
	mStringChannel = subscribe<void>("String");
	mCharChannel = subscribe<void>("Char");
	mDoubleChannel = subscribe<void>("Double");
}

///////////////////////////////////////////////////////////////////////////////

}}}}

MIRA_REGISTER_CHANNELTYPE(mira::Time);
MIRA_REGISTER_CHANNELTYPE(int);

MIRA_CLASS_SERIALIZATION(mira::fw::channel_promote_test::ns3::TestPublisher, mira::Unit);
MIRA_CLASS_SERIALIZATION(mira::fw::channel_promote_test::ns3::TestSubscriber, mira::Unit);
